/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.util.Collections;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.editor.ResourceURIResolver;

public class ProjectResourceURIResolver
extends ResourceURIResolver
implements PluginAware {
    private String _pluginName;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public String getType() {
        return "project-resource";
    }

    public I18nizableText getLabel(String uri) {
        try {
            Resource resource = (Resource)this._resolver.resolveById(uri);
            return new I18nizableText("plugin" + this._pluginName, "PLUGINS_WORKSPACES_LINK_RESOURCE_LABEL", Collections.singletonList(resource.getResourcePath()));
        }
        catch (UnknownAmetysObjectException e) {
            return new I18nizableText("plugin" + this._pluginName, "PLUGINS_WORKSPACES_LINK_RESOURCE_UNKNOWN");
        }
    }

    protected String getUriPrefix(AmetysObject object, boolean download, boolean absolute, boolean internal) {
        String prefix = super.getUriPrefix(object, download, absolute, internal);
        return prefix + "/_plugins/" + this._pluginName + "/" + this._getProject(object).getName();
    }

    protected String _getSiteName(Resource resource) {
        Project project = this._getProject((AmetysObject)resource);
        return project.getSite().getName();
    }

    protected Project _getProject(AmetysObject resource) {
        for (AmetysObject parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Project)) continue;
            return (Project)parent;
        }
        return null;
    }
}

