/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workspaces.keywords.KeywordJCRDAO;
import org.ametys.plugins.workspaces.keywords.KeywordJCRProvider;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class KeywordsDAO
extends AbstractTagsDAO {
    public static final String ROLE = KeywordsDAO.class.getName();
    private RightManager _rightManager;
    private KeywordJCRDAO _keywordJCRDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._keywordJCRDAO = (KeywordJCRDAO)((Object)manager.lookup(KeywordJCRDAO.ROLE));
    }

    public String getTagProviderEPRole() {
        return KeywordProviderExtensionPoint.ROLE;
    }

    protected List<TagProvider<? extends Tag>> getCustomTagProvider() {
        ArrayList<TagProvider<? extends Tag>> providers = new ArrayList<TagProvider<? extends Tag>>();
        providers.add((TagProvider)this._tagProviderExtPt.getExtension(KeywordJCRProvider.class.getName()));
        return providers;
    }

    @Callable
    public Map<String, Object> getKeywords() {
        ArrayList tags = new ArrayList();
        for (String id : this._tagProviderExtPt.getExtensionsIds()) {
            TagProvider tagProvider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            Map someTags = tagProvider.getTags(Collections.emptyMap());
            tags.addAll(this._tagsToJSON(someTags.values()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("keywords", tags);
        result.put("canCreate", this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW);
        return result;
    }

    protected AbstractJCRTagsDAO _getTagJCRDAO() {
        return this._keywordJCRDAO;
    }
}

