/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.workspaces.members.MemberHelper;
import org.ametys.runtime.model.View;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RelatedMembersGenerator
extends ServiceableGenerator {
    private MemberHelper _memberHelper;
    private ContentTypesHelper _contentTypeHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._memberHelper = (MemberHelper)((Object)smanager.lookup(MemberHelper.ROLE));
        this._contentTypeHelper = (ContentTypesHelper)this.manager.lookup(ContentTypesHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"related-members");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Content content = (Content)request.getAttribute(Content.class.getName());
        try {
            List<Content> relatedMembers = this._memberHelper.getRelatedMembers(content, 6);
            for (Content relatedMember : relatedMembers) {
                View view = this._contentTypeHelper.getView("abstract", new String[]{"org.ametys.plugins.workspaces.Content.member"}, new String[0]);
                relatedMember.toSAX(this.contentHandler, new Locale(content.getLanguage()), view, false);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to search related members with common skills and keywords", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"related-members");
        this.contentHandler.endDocument();
    }
}

