/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractProfileStorageBasedAccessController;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.rights.ResourceAccessController;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.accesscontroller.ProjectAccessController;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.StringUtils;

public class ModuleResourceAccessController
extends ResourceAccessController
implements Contextualizable {
    private ProjectManager _projectManager;
    private SiteManager _siteManager;
    private Context _context;
    private WorkspaceModuleExtensionPoint _moduleEP;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean isSupported(Object object) {
        String path = null;
        if (object instanceof ExplorerNode) {
            ExplorerNode node = (ExplorerNode)object;
            path = node.getPath();
        } else if (object instanceof Resource) {
            Resource resource = (Resource)object;
            path = resource.getPath();
        }
        if (path != null) {
            return path.startsWith("/ametys:plugins/workspaces/projects/") && path.contains("/ametys-internal:resources/");
        }
        return false;
    }

    protected boolean _isSupportedStoredContext(Object storedObject) {
        List<Project> projects;
        String siteName;
        Site site;
        if (this.isSupported(storedObject) && (site = this._siteManager.getSite(siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context)))) != null && !(projects = this._projectManager.getProjectsForSite(site)).isEmpty()) {
            String path = ((AmetysObject)storedObject).getPath();
            return path.contains("/ametys:plugins/workspaces/projects/" + projects.get(0).getName());
        }
        return false;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        return null;
    }

    protected I18nizableText _getExplanationI18nText(AbstractProfileStorageBasedAccessController.PermissionDetails details) {
        return new I18nizableText("plugin.workspaces", this._getAccessExplanationI18nKey("PLUGINS_WORKSPACES_MODULE_RESOURCE_ACCESS_CONTROLLER_", details), this._getExplanationI18nParams(details));
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        Map<String, I18nizableText> params = Map.of("path", this._getObjectLabelWithPath(object));
        if (object instanceof Resource) {
            return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_MODULE_RESOURCE_ACCESS_CONTROLLER_RESOURCE_CONTEXT_EXPLANATION_LABEL", params);
        }
        if (object instanceof ExplorerNode) {
            ExplorerNode node = (ExplorerNode)object;
            AmetysObject parent = node.getParent();
            if (StringUtils.equals((CharSequence)parent.getName(), (CharSequence)"ametys-internal:resources")) {
                return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_MODULE_RESOURCE_ACCESS_CONTROLLER_MODULE_CONTEXT_EXPLANATION_LABEL", params);
            }
            return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_MODULE_RESOURCE_ACCESS_CONTROLLER_FOLDER_CONTEXT_EXPLANATION_LABEL", params);
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) throws RightsException {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_MODULE_RESOURCE_ACCESS_CONTROLLER_MODULE_CONTEXT_LABEL", Map.of("path", this._getObjectLabelWithPath(object)));
    }

    private I18nizableText _getObjectLabelWithPath(Object object) {
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_PATH", Map.of("parent", this.getObjectLabel(resource.getParent()), "child", new I18nizableText(resource.getName())));
        }
        if (object instanceof ExplorerNode) {
            ExplorerNode node = (ExplorerNode)object;
            AmetysObject parent = node.getParent();
            if (StringUtils.equals((CharSequence)parent.getName(), (CharSequence)"ametys-internal:resources")) {
                return this._moduleEP.getModuleByName(node.getName()).getModuleTitle();
            }
            return new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_RESOURCE_ACCESS_CONTROLLER_PATH", Map.of("parent", this.getObjectLabel(node.getParent()), "child", new I18nizableText(node.getName())));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return ProjectAccessController.WORKSPACE_CONTEXT_CATEGORY;
    }
}

