/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class WorkspacesStatisticsProvider
implements StatisticsProvider,
Serviceable,
PluginAware {
    private ProjectManager _projectManager;
    private WorkspaceModuleExtensionPoint _workspaceModuleEP;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public Statistics getStatistics() {
        return new StatisticsNode(this._id, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_LABEL"), "ametysicon-abecedary4", null, List.of(this._configStats(), this._projectsStats(), this._modulesStats()), true);
    }

    private StatisticsNode _configStats() {
        boolean configChat = (Boolean)Config.getInstance().getValue("workspaces.chat.active", false, (Object)false);
        boolean configVisio = configChat && StringUtils.isNotBlank((CharSequence)((CharSequence)Config.getInstance().getValue("workspaces.chat.video.url", false, (Object)"")));
        boolean configOOPreview = (Boolean)Config.getInstance().getValue("workspaces.onlyoffice.enabled", false, (Object)false);
        boolean configOOEdit = configOOPreview && (Boolean)Config.getInstance().getValue("workspaces.onlyoffice.edition.enabled", false, (Object)false) != false;
        boolean configWebdav = (Boolean)Config.getInstance().getValue("workspaces.msoffice.enabled", false, (Object)false);
        return new StatisticsNode("config", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_LABEL"), "ametysicon-gear39", (Object)((configChat ? 1 : 0) + (configVisio ? 1 : 0) + (configOOPreview ? 1 : 0) + (configOOEdit ? 1 : 0) + (configWebdav ? 1 : 0)), List.of(new StatisticsValue("chat", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_CHAT_LABEL"), "ametysicon-object-megaphone", (Object)configChat), new StatisticsValue("visio", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_VISIO_LABEL"), "ametysicon-object-camera", (Object)configVisio), new StatisticsValue("oopreview", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_OOPREVIEW_LABEL"), "ametysicon-code-html-picture62", (Object)configOOPreview), new StatisticsValue("ooedit", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_OOEDIT_LABEL"), "ametysicon-editor-indent-more", (Object)configOOEdit), new StatisticsValue("webdav", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_CONFIG_WEBDAV_LABEL"), "ametysicon-file-extension-doc", (Object)configWebdav)), false);
    }

    private StatisticsNode _modulesStats() {
        List<Map<String, Object>> projectsStatistics = this._projectManager.getProjectsStatisticsForClientSide();
        ArrayList<Statistics> modulesStats = new ArrayList<Statistics>();
        for (WorkspaceModule module : this._workspaceModuleEP.getModules()) {
            modulesStats.add(this._moduleStat(projectsStatistics, module));
        }
        return new StatisticsNode("modules", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_LABEL"), "ametysicon-puzzle-piece1", null, modulesStats, true);
    }

    private Statistics _moduleStat(List<Map<String, Object>> projectsStatistics, WorkspaceModule module) {
        long totalActivated = 0L;
        long totalSize = 0L;
        long maxSize = 0L;
        ArrayList<Long> sizes = new ArrayList<Long>();
        long totalCount = 0L;
        long maxCount = 0L;
        ArrayList<Long> counts = new ArrayList<Long>();
        for (Map<String, Object> oneProjectStatistics : projectsStatistics) {
            String numberKey;
            if (!((Boolean)oneProjectStatistics.get(module.getModuleName() + "$activated")).booleanValue()) continue;
            ++totalActivated;
            long size = (Long)oneProjectStatistics.get(module.getModuleName() + "$size");
            if (size > 0L) {
                totalSize += size;
                maxSize = Math.max(maxSize, size);
                sizes.add(size);
            }
            if ((numberKey = (String)oneProjectStatistics.keySet().stream().filter(k -> k.startsWith(module.getModuleName() + "$") && k.endsWith("_number")).findFirst().orElse(null)) == null) continue;
            long count = ((Number)oneProjectStatistics.get(numberKey)).longValue();
            totalCount += count;
            maxCount = Math.max(maxCount, count);
            counts.add(count);
        }
        counts.sort(null);
        sizes.sort(null);
        return new StatisticsNode(module.getModuleName(), module.getModuleTitle(), "ametysicon-puzzle33", (Object)totalActivated, List.of(new StatisticsNode("count", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_COUNT_LABEL"), "ametysicon-maths-abacus", (Object)totalCount, List.of(new StatisticsValue("max", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_COUNT_MAX_LABEL"), "ametysicon-sort51", (Object)maxCount), new StatisticsValue("median", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_COUNT_MEDIAN_LABEL"), "ametysicon-maths-window-symbol-x", (Object)(counts.size() > 0 ? (Long)counts.get(counts.size() / 2) : 0L))), false), new StatisticsNode("size", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_SIZE_LABEL"), "ametysicon-code-css-letter-spacing", (Object)totalSize, List.of(new StatisticsValue("max", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_SIZE_MAX_LABEL"), "ametysicon-sort51", (Object)maxSize), new StatisticsValue("median", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_MODULES_SIZE_MEDIAN_LABEL"), "ametysicon-maths-window-symbol-x", (Object)(sizes.size() > 0 ? (Long)sizes.get(sizes.size() / 2) : 0L))), false)), false);
    }

    private StatisticsNode _projectsStats() {
        long nbPrivate = 0L;
        long nbModerated = 0L;
        long nbPublic = 0L;
        block5: for (Project project : this._projectManager.getProjects()) {
            switch (project.getInscriptionStatus()) {
                case OPEN: {
                    ++nbPublic;
                    continue block5;
                }
                case MODERATED: {
                    ++nbModerated;
                    continue block5;
                }
                case PRIVATE: {
                    ++nbPrivate;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown inscriptionStatus " + project.getInscriptionStatus().toString() + " for project " + project.getId());
        }
        return new StatisticsNode("count", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_PROJECTS_LABEL"), "ametysicon-file98", (Object)(nbPrivate + nbModerated + nbPublic), List.of(new StatisticsValue("open", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_PROJECTS_OPEN_LABEL"), "ametysicon-body-group", (Object)nbPublic), new StatisticsValue("moderated", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_PROJECTS_MODERATED_LABEL"), "ametysicon-body-people-tie", (Object)nbModerated), new StatisticsValue("private", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STATISTICS_PROJECTS_PRIVATE_LABEL"), "ametysicon-body-people", (Object)nbPrivate)), false);
    }
}

