/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.user;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserComponent
implements Component,
Serviceable {
    public static final String ROLE = UserComponent.class.getName();
    private UserManager _userManager;
    private UserPopulationDAO _userPopulationDAO;
    private UserHelper _userHelper;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable
    public Map<String, Object> getUsers(String siteName, int count, int offset, String search, String zoneItemId) {
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        ModelAwareDataHolder serviceDataHolder = zoneItem.getServiceParameters();
        String[] populationIds = serviceDataHolder.getValue("populationIds") != null ? (String[])serviceDataHolder.getValue("populationIds") : new String[]{};
        Map<String, String> parameters = Collections.singletonMap("pattern", search);
        List usersByContext = new ArrayList();
        if (populationIds.length == 0) {
            HashSet contexts = Sets.newHashSet((Object[])new String[]{"/sites/" + siteName, "/sites-fo/" + siteName});
            usersByContext = this._userManager.getUsersByContext((Set)contexts, count, offset, parameters, true, true);
        } else {
            List userPopulations = Arrays.stream(populationIds).map(userPopulationId -> this._userPopulationDAO.getUserPopulation(userPopulationId)).collect(Collectors.toList());
            usersByContext = this._userManager.getUsers(userPopulations, count, offset, parameters, true);
        }
        List usersAsJson = usersByContext.stream().map(arg_0 -> ((UserHelper)this._userHelper).user2json(arg_0)).collect(Collectors.toList());
        return Collections.singletonMap("users", usersAsJson);
    }
}

