/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.wall;

import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.ametys.cms.content.RichTextHandler;
import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.type.ResourceElementTypeHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.wall.WallContentModule;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.solr.client.solrj.SolrServerException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class WallContentManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = WallContentManager.class.getName();
    public static final String WALL_CONTENT_PIN_TAG = "WORKSPACES_CONTENT_PINNED";
    private static final int __INITIAL_WORKFLOW_ACTION_ID = 1111;
    private static final String __WORKFLOW_NAME = "wall-content";
    private FOContentCreationHelper _foContentHelper;
    private ContentTypeExtensionPoint _cTypeEP;
    private I18nUtils _i18nUtils;
    private ContentDAO _contentDAO;
    private ObservationManager _observationManager;
    private RightManager _rightManager;
    private AmetysObjectResolver _resolver;
    private UserManager _userManager;
    private CurrentUserProvider _currentUserProvider;
    private ProjectManager _projectManager;
    private SiteManager _siteManager;
    private ServiceManager _smanager;
    private UploadManager _uploadManager;
    private SolrIndexer _solrIndexer;
    private WorkspaceModuleExtensionPoint _moduleEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._smanager = manager;
        this._foContentHelper = (FOContentCreationHelper)manager.lookup(FOContentCreationHelper.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._uploadManager = (UploadManager)manager.lookup(UploadManager.ROLE);
        this._solrIndexer = (SolrIndexer)manager.lookup(SolrIndexer.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable
    public Map<String, Object> publishContent(String text, Part part, String siteName, String lang) {
        Map<String, Object> results = new HashMap<String, Object>();
        try {
            ContentType cType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.workspaces.Content.wallContent");
            String contentTitle = this._i18nUtils.translate((I18nizable)cType.getDefaultTitle(), lang);
            HashMap<String, Object> userValues = new HashMap<String, Object>();
            userValues.put("title", contentTitle);
            userValues.put("content", text);
            userValues.put("comment", true);
            if (part != null) {
                try (InputStream is = part.getInputStream();){
                    Upload upload = this._uploadManager.storeUpload(this._currentUserProvider.getUser(), part.getFileName(), is);
                    Binary fileValue = ResourceElementTypeHelper.binaryFromUpload((Upload)upload);
                    userValues.put("illustration", Map.of("image", fileValue));
                }
                catch (IOException e) {
                    this.getLogger().error("Failed to store uploaded wall content illustration", (Throwable)e);
                }
            }
            try {
                results = this._foContentHelper.createAndEditContent(1111, "org.ametys.plugins.workspaces.Content.wallContent", siteName, contentTitle, contentTitle, lang, userValues, __WORKFLOW_NAME, null);
                Content content = (Content)results.get(Content.class.getName());
                this._notifyContentCreation(content);
                results.remove(Content.class.getName());
                results.put("success", true);
            }
            finally {
                this._commitAllChanges();
            }
        }
        catch (WorkflowException | AmetysRepositoryException e) {
            results.put("success", false);
            this.getLogger().error("Failed to create wall content for site {} and language {}", new Object[]{siteName, lang, e});
        }
        return results;
    }

    protected void _commitAllChanges() {
        List futuresForRequest = this._observationManager.getFuturesForRequest();
        for (ObservationManager.ObserverFuture observerFuture : futuresForRequest) {
            if (!observerFuture.traits().contains("indexing")) continue;
            try {
                observerFuture.future().get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.getLogger().info("An exception occured when calling #get() on Future result of an observer.", (Throwable)e);
            }
        }
        try {
            this._solrIndexer.commit();
        }
        catch (IOException | SolrServerException e) {
            this.getLogger().error("Impossible to commit changes", e);
        }
    }

    private void _notifyContentCreation(Content content) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("content", content);
        eventParams.put("content.id", content.getId());
        this._observationManager.notify(new Event("wallcontent.added", content.getCreator(), eventParams));
    }

    @Callable
    public Map<String, Object> pinContent(String contentId, Map<String, Object> contextualParameters) {
        return this._pinOrUnpinContent(contentId, contextualParameters, ContentDAO.TagMode.INSERT);
    }

    @Callable
    public Map<String, Object> unpinContent(String contentId, Map<String, Object> contextualParameters) {
        return this._pinOrUnpinContent(contentId, contextualParameters, ContentDAO.TagMode.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> _pinOrUnpinContent(String contentId, Map<String, Object> contextualParameters, ContentDAO.TagMode mode) {
        try {
            Map result;
            Map map = result = this._contentDAO.tag(Collections.singletonList(contentId), Collections.singletonList(WALL_CONTENT_PIN_TAG), mode, contextualParameters, true);
            return map;
        }
        finally {
            this._commitAllChanges();
        }
    }

    @Callable
    public boolean reportContent(String siteName, String contentId) {
        Project project;
        List<String> recipients;
        Content content = (Content)this._resolver.resolveById(contentId);
        User reporter = this._userManager.getUser(this._currentUserProvider.getUser());
        Site site = this._siteManager.getSite(siteName);
        this._contentDAO.report(content);
        List<Project> projects = this._projectManager.getProjectsForSite(site);
        if (!projects.isEmpty() && !(recipients = this._getReportsRecipients(project = projects.get(0))).isEmpty()) {
            HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
            i18nParams.put("projectTitle", new I18nizableText(project.getTitle()));
            i18nParams.put("siteTitle", new I18nizableText(site.getTitle()));
            I18nizableText i18nSubject = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WALL_CONTENT_REPORTED_SUBJECT", i18nParams);
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject, content.getLanguage());
            i18nParams.put("projectUrl", new I18nizableText(site.getUrl()));
            i18nParams.put("reporter", new I18nizableText(reporter.getFullName()));
            i18nParams.put("content", new I18nizableText(this.getExcerpt(content, 200)));
            String from = (String)site.getValue("site-mail-from");
            try {
                String htmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(i18nSubject).withLanguage(content.getLanguage()).withMessage(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WALL_CONTENT_REPORTED_BODY", i18nParams)).withDetails(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WALL_CONTENT_REPORTED_BODY_EXTRACT"), this.getExcerpt(content, 200), false).withLink(site.getUrl(), new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT")).build();
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withSender(from).withRecipients(recipients).sendMail();
                return true;
            }
            catch (MessagingException | IOException e) {
                this.getLogger().warn("Could not send a notification mail to {}", recipients, (Object)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getExcerpt(Content content, int maxLength) {
        if (content.hasValue("content")) {
            String string;
            InputStream is;
            SAXParser saxParser;
            block11: {
                RichText richText = (RichText)content.getValue("content");
                saxParser = null;
                is = richText.getInputStream();
                RichTextHandler txtHandler = new RichTextHandler(maxLength);
                saxParser = (SAXParser)this._smanager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(is), (ContentHandler)txtHandler);
                string = txtHandler.getValue();
                if (is == null) break block11;
                is.close();
            }
            this._smanager.release((Object)saxParser);
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.getLogger().error("Cannot extract excerpt from content {}", (Object)content.getId(), (Object)e);
                            this._smanager.release(saxParser);
                        }
                    }
                    catch (Throwable throwable3) {
                        this._smanager.release(saxParser);
                        throw throwable3;
                    }
                }
            }
        }
        return "";
    }

    protected List<String> _getReportsRecipients(Project project) {
        Object module = this._moduleEP.getModule(WallContentModule.WALLCONTENT_MODULE_ID);
        ModifiableResourceCollection moduleRoot = module.getModuleRoot(project, false);
        Set users = this._rightManager.getAllowedUsers("Plugins_Workspaces_Right_ReportNotification_WallContent", (Object)moduleRoot).resolveAllowedUsers(((Boolean)Config.getInstance().getValue("runtime.mail.massive.sending")).booleanValue());
        return users.stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).map(user -> user.getEmail()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    @Callable
    public Map<String, Object> react(String contentId, String reactionName, boolean remove) {
        return this._contentDAO.react(contentId, reactionName, remove);
    }
}

