/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
var siteManager = Ametys.serviceManager.lookup(org.ametys.web.repository.site.SiteManager.ROLE);

var catalogSiteName = projectManager.getCatalogSiteName();
var catalogSite = siteManager.getSite(catalogSiteName);

if (catalogSite != null)
{
    logger.info("##### Starting to move project site under the catalog site… #####")
    var jcrQuery = "//element(*, ametys:project)";
    logger.info("Migration of default JCR workspace started…");
    Repository.query(jcrQuery, true, Repository.session).forEach(
        project => {
            moveSitesUnderCatalogSite(project);
        });
    
    logger.info("Migration of live JCR workspace started…");
    Repository.query(jcrQuery, true, Repository.liveSession).forEach(
        project => {
            moveSitesUnderCatalogSite(project);
        });

    logger.info("####### Move of project site under the catalog site done. #######")
}


function moveSitesUnderCatalogSite(project) {
    var currentSession = project.getNode().getSession();
    let projectSite = project.getSite();
    try
    {
        projectSite = Repository.resolver.resolveById(projectSite.getId(), currentSession); // see WORKSPACES-1241
        // We only move the site that are at root
        if (projectSite.getParentSite() == null) {
            if (projectSite.canMoveTo(catalogSite)) {
                projectSite.moveTo(catalogSite, false); // we don't want to rename.
                logger.info("Moved site " + projectSite.getName() + " for project " + project.getName() + " under the catalog site.");
            }
            else {
                logger.error("Failed to move the site " + projectSite.getName() + " for project " + project.getName() + " under the catalog site.");
            }
        }
        else
        {
            logger.warn("Site " + projectSite.getName() + " is not located at sites root and will be ignored.")
        }
    }
    catch (e)
    {
        logger.error("Failed to move the site " + projectSite.getName() + " for project " + project.getName() + ". The site couldn't be found in workspace " + currentSession.getWorkspace().getName() + ".", e)
    }
    currentSession.save();
}
