<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys escape math user resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">modular-search</xsl:variable>
    <xsl:variable name="common-service-name">modular-search</xsl:variable>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-js"/>
    </xsl:template>
    
    <xsl:template name="search-js">
        <script type="text/javascript">
        
            function showResultAdditionCallback_<xsl:value-of select="$uniqueId"/>(data, firstLoad) 
            {
                // Nothing. To override if necessary;
            }
            
            function showResultAdditionCallbackByModule_<xsl:value-of select="$uniqueId"/>(data, moduleId, hits) 
            {
                // Nothing. To override if necessary;
            }
            
            function loadMore_<xsl:value-of select="$uniqueId"/>(moduleId)
            {
                let $search = $j('#modular-search-<xsl:value-of select="$uniqueId"/>');
                let $moduleOffset = $search.find('*[data-search-offset="' + moduleId + '"]');
                let offset = $moduleOffset.val();
                
                doSearch_<xsl:value-of select="$uniqueId"/>(false, moduleId, offset);
            }
            
            function doSearch_<xsl:value-of select="$uniqueId"/>(firstLoad, moduleId, offset)
            {
                let $search = $j('#modular-search-<xsl:value-of select="$uniqueId"/>');
                let $form = $search.find('*[data-search-form]');
                
                var data = {
                    siteName: "<xsl:value-of select="$site"/>",
                    lang: "<xsl:value-of select="$lang"/>"
                }
                
                if (!firstLoad &amp;&amp; moduleId != null)
                {
                    data.moduleId = moduleId;
                    data.offset = offset;
                }
                
                $form.find("select").each(function (i, select) {
                    data[select.name] = $j(select).val().join(',');
				});
                $form.find("input").each(function (i, input) {
                    data[input.name] = input.value;
                });
                
	            $j.ajax({
	                url: "<xsl:value-of select="$site-uri-prefix"/>/_plugins/workspaces/service/search.xml",
	                type: 'POST',
	                data: data,
                    dataType: "xml",
	                success: showResults,
	                error: handleError
	            });
                
                function handleError(jqXHR, textStatus, errorThrown)
                {
                   alert("<i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_XHR_ERROR" />");
                }
                
                function showResults(data)
                {
                    if (firstLoad)
                    {
	                    let totalCount = 0;
                        
	                    $j(data).find('search > modules > module').each(function(){
	                    
	                        let moduleId = $j(this).attr("id");
	                        let hits = $j(this).find("hits");
	                        let results = hits.find("*[data-module-hits]").html();
	                        
	                        let count = Number(hits.attr("total"));
	                        totalCount += count;
	                        
	                        let $moduleCount = $search.find('*[data-results-count="' + moduleId + '"]');
                            let $moduleAllResults = $search.find('*[data-search-all-results="' + moduleId + '"]');
	                        let $moduleResults = $search.find('*[data-search-results="' + moduleId + '"]');
	                        
	                        $moduleCount.html(count);
	                        $moduleResults.html(results);
                            
                            let minLimit = Number(hits.attr("minLimit"));
                            $moduleAllResults.html("");
                            hits.find("*[data-module-hit]").each(function(i, hit){
                                if (i &lt; minLimit)
                                {
                                    $moduleAllResults.append(hit.outerHTML);
                                }
                            }); 
                            
                            let $moduleHead = $search.find('*[data-results-tab-head="' + moduleId + '"]');
                            let $moduleAll = $search.find('*[data-results-tab-all="' + moduleId + '"]');
                            let $moduleContent = $search.find('*[data-results-tab-content="' + moduleId + '"]');
                            if (count > 0)
                            {
                                $moduleHead.removeClass('disabled');
                                $moduleAll.show();
                                $moduleContent.show();
                            }
                            else
                            {
                                $moduleHead.addClass('disabled');
                                $moduleAll.hide();
                                $moduleContent.hide();
                            }
                            
                            let limit = Number(hits.attr("limit"));
	                        if (limit >= count)
	                        {
	                            $search.find('*[data-search-more-button="' + moduleId + '"]').hide();
	                        }
                            else
                            {
                                $search.find('*[data-search-more-button="' + moduleId + '"]').show();
                            }
                            
                            showResultAdditionCallbackByModule_<xsl:value-of select="$uniqueId"/>(data, moduleId, hits);
	                    });
	                    
                        let $total = $search.find('*[data-search-total-results-count]');
                        $total.html(totalCount);
                        $total = $search.find('*[data-results-count="all"]');
                        $total.html(totalCount);
                        let $allTabHead = $search.find('[data-results-tab-head=all]');
                        if (totalCount == 0)
                        {
                            $allTabHead.addClass('disabled');
                        }
                        else
                        {
                            $allTabHead.removeClass('disabled');
                        }
                        
                        var textfield = $j(data).find('search > filters > textfield').html();
                        let $textfield = $search.find('*[data-search-textfield]');
                        $textfield.find('*[data-search-textfield-value]').html(textfield);
                        if (textfield != '')
                        {
                            $textfield.show();
                        }
                        else
                        {   
                            $textfield.hide();
                        }
                        
                        $search.find('*[data-search-total-results]').show();
                    }
                    else
                    {
                        // insert new results
                        let nextHits = $j(data).find('search > module > hits');
                        let nextResults = nextHits.find("*[data-module-hits]").html();
                        
                        let $moduleResults = $search.find('*[data-search-results="' + moduleId + '"]');
                        $moduleResults.append(nextResults);
                        
                        // update offset
                        let offset = Number(nextHits.attr("offset"));
                        let limit = Number(nextHits.attr("limit"));
                        let $moduleOffset = $search.find('*[data-search-offset="' + moduleId + '"]');
                        $moduleOffset.val(offset+limit);
                        
                        let total = Number(nextHits.attr("total"));
                        if (offset+limit >= total)
                        {
                            $search.find('*[data-search-more-button="' + moduleId + '"]').hide();
                        }
                    }
                    
                    showResultAdditionCallback_<xsl:value-of select="$uniqueId"/>(data, firstLoad);
                }
            }
            
            $j(document).ready(function() {doSearch_<xsl:value-of select="$uniqueId"/>(true)});
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="modular-search-{$uniqueId}">
	        <xsl:call-template name="results-count" />
	        <xsl:call-template name="filters" />
	        
            <div id="tabs-{$uniqueId}">
    	        <xsl:call-template name="modules-header"/>
    	        <xsl:call-template name="modules-content"/>
            </div>
        </div>
        
        <script type="text/javascript">
            $("#tabs-<xsl:value-of select="$uniqueId"/>").tabs();
        </script>        
    </xsl:template>
    
    <xsl:template name="results-count">
        <div style="display: none" data-search-total-results="true" class="results-count">
            <span data-search-total-results-count="true"></span>
            
            <xsl:choose>
                <xsl:when test="/search/filters/textfield">
                    <xsl:text> </xsl:text>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_RESULTS_FOR"/>
                    <strong><xsl:value-of select="/search/filters/textfield"/></strong>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> </xsl:text>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_RESULTS"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>    
    
    <xsl:template name="filters">
        <form method="POST" action="" data-search-form="true">
            <input type="hidden" name="textfield" value="{/search/filters/textfield}" data-search-textfield-value="true"/>
            <xsl:call-template name="projects-filter"/>
            <xsl:call-template name="categories-filter"/>
        </form>
    </xsl:template>
    
    <xsl:template name="projects-filter">
        <div class="projects-filter">
            <label><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_FILTER_PROJECTS" /></label>
            <select name="project" onchange="doSearch_{$uniqueId}(true)">
                <option value=""><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_ALL_PROJECTS" /></option>
                <xsl:for-each select="/search/projects/project">
                    <xsl:sort select="title"/>
                    <option value="{@name}"><xsl:value-of select="."/></option>        
                </xsl:for-each>
            </select>
        </div>
    </xsl:template>    
    
    <xsl:template name="categories-filter">
        <div class="categories-filter">
            <label><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_FILTER_CATEGORIES" /></label>
            <select name="category" onchange="doSearch_{$uniqueId}(true)">
                <option value=""><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_ALL_CATEGORIES" /></option>
                <xsl:for-each select="/search/categories/category">
                    <xsl:sort select="title"/>
                    <option value="{@name}"><xsl:value-of select="title"/></option>        
                </xsl:for-each>
            </select>
        </div>
    </xsl:template>    
    
    <xsl:template name="modules-header">
        <ul class="search-tabs-header" role="tablist">
            <li data-results-tab-head="all">
                <a href="#tab-all" role="tab"><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_TAB_ALL" />(<span data-results-count="all"></span>)</a>
            </li>
            <xsl:apply-templates select="/search/modules/module" mode="tab-head">
                <xsl:sort select="@order" data-type="number"/>
            </xsl:apply-templates>
        </ul>
    </xsl:template>
    
    <xsl:template match="module" mode="tab-head">
        <li data-results-tab-head="{@id}">
            <a href="#tab-{@id}"><xsl:value-of select="title"/> (<span data-results-count="{@id}">0</span>)</a>
        </li>
    </xsl:template>
    
    <xsl:template name="modules-content">
        <div class="tab-content">
            <xsl:call-template name="tab-all"/>
            
            <xsl:apply-templates select="/search/modules/module" mode="tab-content">
                <xsl:sort select="@order" data-type="number"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>  
    
    <xsl:template name="tab-all">
        <div id="tab-all" role="tabpanel">
		    <xsl:apply-templates select="/search/modules/module" mode="tab-all"/>
        </div>
    </xsl:template>
    
    <xsl:template match="module" mode="tab-all">
        <div class="ametys-search" data-results-tab-all="{@id}">
            <h2 class="ametys-search-header"><xsl:value-of select="title"/></h2>
            <div class="ametys-search-results" data-search-all-results="{@id}">
                <!-- Here the search results will be loaded -->
            </div>
        </div>
    </xsl:template>  
    
    <xsl:template match="module" mode="tab-content">
        <div id="tab-{@id}" role="tabpanel">
            <div class="ametys-search" data-results-tab-content="{@id}">
                <h2 class="ametys-search-header"><xsl:value-of select="title"/></h2>
                <div class="ametys-search-results" data-search-results="{@id}">
                    <!-- Here the search results will be loaded -->
                </div>
            </div>
            
            <div data-search-next-results="{@id}"/>
            
            <xsl:call-template name="load-more"/>
        </div>
    </xsl:template>  
    
    <xsl:template name="load-more">
        <input data-search-offset="{@id}" type="hidden" value="{@limit}"/>
        <button data-search-more-button="{@id}" class="ametys-search-btn-load-more" onclick="loadMore_{$uniqueId}('{@id}')"><i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_PAGE_LOAD_MORE_RESULTS" /></button>
    </xsl:template>
    
    
</xsl:stylesheet>
