/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the JCR tags in a tree 
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.keyword.tool.KeywordsTool', {
    extend : 'Ametys.plugins.cms.tag.tool.TagsTool',

    _tagTooltipTpl : Ext.create('Ext.XTemplate', [
                         '<tpl if="description && description != \'\'">',
                            '{description}<br/>',
                         '</tpl>'
    ]),
    
    _rootNodeLabel : "{{i18n PLUGINS_WORKSPACES_KEYWORDS_ROOT_NODE_LABEL}}",
       
    getTagProviderId: function()
    {
    	return 'org.ametys.plugins.workspaces.keywords.KeywordJCRProvider';
    },
    
    getTagProviderEPId: function()
    {
    	return 'org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint';
    },
    
    getTagDAO: function()
    {
    	return 'org.ametys.plugins.workspaces.keywords.KeywordJCRDAO';
    },
    
    getTagModel: function()
    {
    	return 'Ametys.plugins.workspaces.project.keyword.KeywordNode';
    },
    
    getTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_KEYWORD;
    },
    
    getRootTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_KEYWORD_ROOT;
    },

	_getTooltip: function(node)
	{
		var title = node.get('name');
		if (node.get("title") != null)
		{
			title = node.get('title') + " (" + title + ")";
		}
		
		var text = this._tagTooltipTpl.applyTemplate ({
			description: node.get('description')
		});
		
		return {
			title: title,
			glyphIcon: node.get('tooltipIconCls'),
			imageWidth: 48,
			imageHeight: 48,
			text: text,
			inribbon: false
		};
	},
    
	_updateAdditionalInfo : function (node, response)
    {
		//No additional info
    }
});

Ext.define("Ametys.message.ProjectKeywordMessageTarget",
    {
		override: "Ametys.message.MessageTarget",

	    statics: 
	    {
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_KEYWORD The target type is a tag. The expected parameters are:
	         * @property {String} PROJECT_KEYWORD.id The id of tag
	         * @property {String} PROJECT_KEYWORD.parentId The id of the parent of the tag
	         * @property {String} PROJECT_KEYWORD.name The name of tag
	         */
	    	PROJECT_KEYWORD: "project-keyword",
	
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_KEYWORD_ROOT The target type is a tag root. The expected parameters are:
	         * @property {String} PROJECT_KEYWORD_ROOT.id The id of root tag
	         * @property {String} PROJECT_KEYWORD_ROOT.name The name of root tag 
	         */
	    	PROJECT_KEYWORD_ROOT: "project-keyword-root"
	    }
    }
);
