<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
                              
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:template name="title">
        <xsl:variable name="titleKey">
            <xsl:choose>
                <xsl:when test="member/user">PROJECT_MAIL_MANAGER_NOTIFICATION_BODY_USER_<xsl:value-of select="/notification/eventKey"/>_TITLE</xsl:when>
                <xsl:when test="member/group">PROJECT_MAIL_MANAGER_NOTIFICATION_BODY_GROUP_<xsl:value-of select="/notification/eventKey"/>_TITLE</xsl:when>
            </xsl:choose>
        </xsl:variable>
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="{$titleKey}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
                <i18n:param name="userFullname"><xsl:value-of select="member/user/fullname"/></i18n:param>
                <i18n:param name="groupLabel"><xsl:value-of select="member/group/label"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
    <xsl:template name="section-items">
        <items>
            <xsl:apply-templates select="member"/>
        </items>
    </xsl:template>
    
    <xsl:template match="member">
        <item type="member">    
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="author"/>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="memberType"/>
            <xsl:apply-templates select="." mode="identity"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
        </item>
    </xsl:template>
    
    <xsl:template match="member[user]" mode="title">
        <title><xsl:value-of select="user/fullname"/></title>
    </xsl:template>
    
    <xsl:template match="member[group]" mode="title">
        <title><xsl:value-of select="group/label"/></title>
    </xsl:template>
    
    <xsl:template match="member" mode="author">
        <author>
            <fullname><xsl:value-of select="/notification/issuer/user/fullname"/></fullname>
        </author>
    </xsl:template>
    
    <xsl:template match="member" mode="memberType">
        <memberType>
            <xsl:choose>
                <xsl:when test="user">user</xsl:when>
                <xsl:when test="group">group</xsl:when>
            </xsl:choose>
        </memberType>
    </xsl:template>
    
    <xsl:template match="member" mode="identity">
        <identity>
            <xsl:choose>
                <xsl:when test="user"><xsl:value-of select="user/@login"/>#<xsl:value-of select="user/@population"/></xsl:when>
                <xsl:when test="group"><xsl:value-of select="group/@id"/>#<xsl:value-of select="group/@groupDirectory"/></xsl:when>
            </xsl:choose>
        </identity>
    </xsl:template>
</xsl:stylesheet>