/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
import Vue from 'vue';
import Chat from './vueserve/Chat.vue';
import Vuex from 'vuex';
import pSBC from 'shade-blend-color';
import i18n from 'i18n';

Vue.config.productionTip = false;

Vue.use(Vuex);
import user from '../../_components/store/chat/user';
import members from '../../_components/store/chat/members';
import { callMethod } from '../../_components/helper/ServerCommHelper';
import AmetysFront from 'AmetysFront';

window['vue-chat-run'] = async function(selector, config)
{
    document.body.parentElement.style.setProperty('--ametys-workspaces-chat-primary-color', config.color);
    document.body.parentElement.style.setProperty('--ametys-workspaces-chat-primary-color-light', pSBC(0.1, config.color));

    try
    {
        let data = await callMethod({
            role: 'org.ametys.plugins.workspaces.chat.ChatHelper',
            methodName: 'login',
            parameters: [config.roomName]
        });
        
        if (data != null)
        {
            const store = new Vuex.Store({
                state: {
                    userId: data.userId,
                    userToken: data.authToken,
                    username: data.userName,
                    adminLogin : config.adminLogin,
                    url: config.url, 
                    roomName: config.roomName
                },
                modules: {
                    user,
                    members 
                }
            });
            
            // Server values
            config.userToken = data.authToken;
            config.userId = data.userId;
            config.initialStatus = data.status;
            config.userName = data.userName;
    
            return new Vue({
                store,
                render: h => h(Chat, {props: config}),
            }).$mount(selector);
        }
    }
    catch (e)
    {
        AmetysFront.Event.fire('loaderFail', {
            title: i18n.PLUGINS_WORKSPACES_CHAT_ERROR,
            text : i18n.PLUGINS_WORKSPACES_CHAT_ERROR_TEXT,
            details: e
        });
    }
};
