/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.minisite;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;

/**
 * Class representing a activity notifier for minisite workspaces
 */
public class MinisiteActivityNotifier extends AbstractWorkspacesActivityNotifier
{
    public boolean support(ActivityType activityType)
    {
        return activityType instanceof MinisiteActivityType;
    }
    
    @Override
    public String getMailBodyURI(Activity activity)
    {
        return "cocoon://_plugins/workspaces/notification-mail-minisite";
    }
    
    @Override
    public AmetysObject getTargetAmetysObject(Activity activity)
    {
        return _resolver.resolveById(activity.getValue(MinisiteActivityType.PAGE_ID));
    }
}
