/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.calendars;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;

/**
 * Abstract class for Calendar DAO's
 *
 */
public abstract class AbstractCalendarDAO extends AbstractWorkspaceDAO
{

    /** Right to add a calendar */
    public static final String RIGHTS_CALENDAR_ADD = "Plugins_Workspaces_Calendar_Add";
    /** Right to edit a calendar */
    public static final String RIGHTS_CALENDAR_EDIT = "Plugins_Workspaces_Calendar_Edit";
    /** Right to delete a calendar */
    public static final String RIGHTS_CALENDAR_DELETE = "Plugins_Workspaces_Calendar_Delete";
    /** Right to add a event */
    public static final String RIGHTS_EVENT_ADD = "Plugins_Workspaces_Event_Add";
    /** Right to edit a event */
    public static final String RIGHTS_EVENT_EDIT = "Plugins_Workspaces_Event_Edit";
    /** Right to edit a event */
    public static final String RIGHTS_OWNED_EVENT_DELETE = "Plugins_Workspaces_Owned_Event_Delete";
    /** Right to delete a event */
    public static final String RIGHTS_EVENT_DELETE = "Plugins_Workspaces_Event_Delete";
    /** Right to delete_own a event */
    public static final String RIGHTS_EVENT_DELETE_OWN = "Plugins_Workspaces_Owned_Event_Delete";
    /** Right to handle a resource */
    public static final String RIGHTS_HANDLE_RESOURCE = "Plugins_Workspaces_Handle_Resource";
    /** Right to book a resource */
    public static final String RIGHTS_BOOK_RESOURCE = "Plugins_Workspaces_Book_Resource";
    

    /** The Messaging connector calendar manager */
    protected MessagingConnectorCalendarManager _messagingConnectorCalendarManager;
            
    /** Explorer resources DAO */
    protected ExplorerResourcesDAO _explorerResourcesDAO;

    /** The color component */
    protected CalendarColorsComponent _calendarColors;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _messagingConnectorCalendarManager = (MessagingConnectorCalendarManager) manager.lookup(MessagingConnectorCalendarManager.ROLE);
        _explorerResourcesDAO = (ExplorerResourcesDAO) manager.lookup(ExplorerResourcesDAO.ROLE);
        _calendarColors = (CalendarColorsComponent) manager.lookup(CalendarColorsComponent.ROLE);
    }

}
