/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.events;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;

import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.core.user.UserIdentity;

/**
 * Modifiable Calendar Event Interface
 */
public interface ModifiableCalendarEvent extends CalendarEvent, ModifiableModelAwareDataAwareAmetysObject
{
    /**
     * Set the title of the event
     * @param title the title
     */
    public void setTitle(String title);
    
    /**
     * Set the description of the event
     * @param desc the description
     */
    public void setDescription(String desc);
    
    /**
     * Set the location of the event
     * @param location the location
     */
    public void setLocation(String location);
    
    /**
     * Set the startDate of the event
     * @param startDate the start date
     */
    public void setStartDate(ZonedDateTime startDate);

    /**
     * Set the endDate of the event
     * @param endDate the end date
     */
    public void setEndDate(ZonedDateTime endDate);
    
    /**
     * Set the date zone of the event
     * @param dateZone the date zone
     */
    public void setZone(ZoneId dateZone);

    /**
     * Set if the event last all the day
     * @param fullDay is a fullday event
     */
    public void setFullDay(Boolean fullDay);
    
    /**
     * Set the creator
     * @param user The creator
     */
    public void setCreator(UserIdentity user);
    
    /**
     * Set the creation date
     * @param date The creation date
     */
    public void setCreationDate(ZonedDateTime date);
    
    /**
     * Set the last contributor
     * @param user The last contributor
     */
    public void setLastContributor(UserIdentity user);
    
    /**
     * Set the last modified date
     * @param date The last modified date
     */
    public void setLastModified(ZonedDateTime date);
    
    /**
     * Set the recurrence type.
     * @param recurrenceType the recurrence type
     */
    public void setRecurrenceType(String recurrenceType);
    /**
     * Set the end date of the frequency.
     * @param untilDate the end date of the recurrence
     */
    public void setRepeatUntil(ZonedDateTime untilDate);
    /**
     * Set the list of excluded event date.
     * @param excludedOccurrences excluded date
     */
    public void setExcludedOccurrences(List<ZonedDateTime> excludedOccurrences);
    
    /**
     * Set the oragniser
     * @param user The oragniser
     */
    public void setOrganiser(UserIdentity user);

    /**
     * Set the resources
     * @param resources The resources
     */
    void setResources(List<String> resources);
    
}
