/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.jcr;

import javax.jcr.Node;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link AmetysObjectFactory} for handling {@link JCRCalendarEvent}s.
 */
public class JCRCalendarResourceFactory extends DefaultAmetysObjectFactory
{
    
    /** JCR nodetype for calendar resources */
    public static final String CALENDAR_RESOURCE_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":calendar-resource";
    
    /** The calendar resource model */
    private Model _calendarResource;
    
    @Override
    public JCRCalendarResource getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new JCRCalendarResource(node, parentPath, this);
    }
    
    /**
     * Get the calendar resource model
     * @return the calendar resource model
     */
    public Model getCalendarResourceModel()
    {
        if (_calendarResource == null)
        {
            try
            {
                String role = ModelItemTypeExtensionPoint.ROLE_MODEL_AWARE_BASIC;
                _calendarResource = Model.of(
                        "calendar.resource.model.id", 
                        "calendar.resource.model.family.id",
                        DefaultElementDefinition.of(JCRCalendarResource.ATTRIBUTE_CALENDAR_RESOURCE_ID, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarResource.ATTRIBUTE_TITLE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarResource.ATTRIBUTE_ICON, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarResource.ATTRIBUTE_INSTRUCTIONS, false, ModelItemTypeConstants.STRING_TYPE_ID, role)
                        );
            }
            catch (Exception e) 
            {
                getLogger().error("An error occurred getting the calendar resource model", e);
                throw new RuntimeException("An error occurred getting the calendar resource model", e);
            }
        }
        return _calendarResource;
    }
}
