/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.catalog;

import org.ametys.web.repository.site.DefaultSiteType;

/**
 * The site type of a catalog
 */
public class CatalogSiteType extends DefaultSiteType
{
    /** Id of the catalog site type */
    public static final String TYPE_ID = "workspaces.catalog";
    
    /** data name for the project URL prefix */
    public static final String PROJECT_URL_PREFIX_SITE_PARAM = "urlPrefix";
    
    /** data name for the project skin */
    public static final String PROJECT_DEFAULT_SKIN_SITE_PARAM = "defaultProjectSkin";
    
    @Override
    public boolean siteInitiallyRestricted()
    {
        return true;
    }
}
