/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.project.objects.Project;

/**
 * Decode the path to get the resource and set the resource in request attributes
 *
 */
public class DecodePathAction extends AbstractAction implements Serviceable
{
    private AmetysObjectResolver _resolver;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String path, Parameters parameters) throws Exception
    {
        Map<String, String> result = new HashMap<>();
        
        // Mostly unnecessary, except for the ';' character
        // {@see org.ametys.plugins.workspaces.documents.WebdavProjectResourceURIResolver}
        String decodedPath = URIUtils.decode(path);
        
        result.put("path", decodedPath);
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        Project project = (Project) request.getAttribute("project"); 
        
        try
        {
            AmetysObject resource = _resolver.resolveByPath(project.getPath() + "/ametys-internal:resources/" + decodedPath);
            request.setAttribute("resource", resource);
        }
        catch (Exception e)
        {
            // does nothing
        }
        
        return result;
    }
}
