/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.documents.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.cms.content.indexing.solr.SolrResourceGroupedMimeTypes;
import org.ametys.plugins.workspaces.WorkspacesHelper.FileType;

/**
 * Get file icon action from mime type
 */
public class GetFileIconAction extends ServiceableAction
{
    /** MIME types for archive */
    protected static final String[] ARCHIVE_MIMETYPE = new String []
    {
        "application/x-rar-compressed",
        "application/octet-stream",
        "application/zip",
        "application/x-zip",
        "application/octet-stream",
        "application/x-zip-compressed",
        "multipart/x-zip",
        "application/tar",
        "application/x-tar",
        "application/x-gtar",
        "multipart/x-tar",
        "application/x-compress",
        "application/x-compressed",
        "application/gzip",
        "application/x-gzip",
        "application/x-gtar",
        "application/x-tgz"
    };
    
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, Object> result = new HashMap<>();
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String mimeType = request.getParameter("mimeType");
        if (Arrays.asList(ARCHIVE_MIMETYPE).contains(mimeType))
        {
            result.put("type", "archive");
        }
        else
        {
            Optional<String> group = SolrResourceGroupedMimeTypes.getGroup(mimeType);
            
            FileType type =  group
                    .map(groupMimeType -> FileType.valueOf(groupMimeType.toUpperCase()))
                    .orElse(FileType.UNKNOWN);
            
            result.put("type", type.name().toLowerCase());
        }
        return result;
    }
}
