/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.html;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLConsumer;

import org.ametys.cms.transformation.AbstractEnhancementHandler;
import org.ametys.cms.transformation.AbstractEnhancementTransformer;
import org.ametys.cms.transformation.EnhancementHandlersExtensionPoint;

/**
 * This cocoon transformer use the DocbookEnhancementExtensionPoint to be based upon a serie of EnhancementHandler
 */
public class HTMLEnhancementTransformer extends AbstractEnhancementTransformer
{
    private HTMLEnhancementExtensionPoint _htmlEnhancementExtensionPoint;
    private EnhancementHandlersExtensionPoint _enhancementHandlersExtensionPoint;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _htmlEnhancementExtensionPoint = (HTMLEnhancementExtensionPoint) smanager.lookup(HTMLEnhancementExtensionPoint.ROLE);
        _enhancementHandlersExtensionPoint = (EnhancementHandlersExtensionPoint) smanager.lookup(EnhancementHandlersExtensionPoint.ROLE);
    }
    
    @Override
    public void setConsumer(XMLConsumer consumer)
    {
        _contentHandler = consumer;
        _lexicalHandler = consumer;
        
        for (String handlerRole : _htmlEnhancementExtensionPoint.getHtml2HTMLHandlers())
        {
            AbstractEnhancementHandler handler = _enhancementHandlersExtensionPoint.getExtension(handlerRole);
            
            handler.setContentHandler(_contentHandler);
            _contentHandler = handler;
            
            handler.setLexicalHandler(_lexicalHandler);
            _lexicalHandler = handler;
        }
    }
   
}
