/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.html;

import org.apache.avalon.framework.component.Component;

import org.ametys.cms.transformation.AbstractRichTextTransformer;
import org.ametys.cms.transformation.RichTextTransformer;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * {@link RichTextTransformer} which convert HTML into HTML.
 */
public class HTMLTransformer extends AbstractRichTextTransformer implements Component, PluginAware
{
    /** Avalon role. */
    public static final String ROLE = HTMLTransformer.class.getName();
    
    private String _pluginName;
    
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _pluginName = pluginName;
    }

    @Override
    protected String _getSourceUriForHTML2RichText()
    {
        return "cocoon://_plugins/" + _pluginName + "/convert/htmleditor2html";
    }

    @Override
    protected String _getSourceUriForRichText2HTML()
    {
        return "cocoon://_plugins/" + _pluginName + "/convert/html2htmleditor";
    }
}
