/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.Map;
import java.util.stream.Collectors;

import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.TagTargetType;

/**
 * This class represent a project keyword as a CMS Tag
 */
public class KeywordCMSTag extends CMSTag
{
    /** The prefix for all tags issue from keywords */
    public static final String TAG_PREFIX = "WORKSPACES_KEYWORD_";
    
    private DefaultTag _keyword;
    
    /**
     * Constructor
     * @param keyword the keyword
     * @param parent the parent CMS tag
     * @param targetType the target type
     */
    public KeywordCMSTag(DefaultTag keyword, CMSTag parent, TagTargetType targetType)
    {
        super(TAG_PREFIX + keyword.getName(), TAG_PREFIX + keyword.getName(), parent, keyword.getTitle(), keyword.getDescription(), TagVisibility.PUBLIC, targetType, 0);
        _keyword = keyword;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public CMSTag getTag(String tagId)
    {
        DefaultTag keyword = _keyword.getTag(tagId);
        return new KeywordCMSTag(keyword, this, this.getTarget());
    }
    
    
    @Override
    public Map<String, CMSTag> getTags()
    {
        return _keyword.getTags().values()
            .stream()
            .map(keyword -> new KeywordCMSTag(keyword, this, this.getTarget()))
            .collect(Collectors.toMap(tag -> tag.getId(), tag -> tag));
    }
}
