/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.web.administration.SuperUserClientSideElement;

import com.google.common.collect.ImmutableList;

/**
 * This implementation creates a control allowing to affect a super user to a given context of a project.
 * This implementation does NOT set the super user on project'site.
 */
public class ProjectSuperUserClientSideElement extends SuperUserClientSideElement
{
    /** The project user manager */
    protected ProjectMemberManager _projectUserManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _projectUserManager = (ProjectMemberManager) smanager.lookup(ProjectMemberManager.ROLE);
    }
    
    @Override
    @Callable
    public void affectUserToProfile(Map<String, String> user, String profileId, Map<String, Object> jsParameters)
    {
        UserIdentity userIdentity = new UserIdentity(user.get("login"), user.get("populationId"));
        _projectUserManager.setProjectManager((String) jsParameters.get("projectName"), profileId, ImmutableList.of(userIdentity));
    }

}
