/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.search;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Interface for search module
 */
public interface SearchModule
{
    /**
     * Get the id
     * @return the id
     */
    public String getId();
    
    /**
     * Get the title of the search
     * @return title of the module
     */ 
    public I18nizableText getTitle();
    
    /**
     * Get the search url
     * @return URL to fetch for search
     */
    public String getSearchUrl();

    /**
     * Get the number of results per page
     * @return Max number of results on the module view
     */
    public int getLimit();

    /**
     * Get the number of results per page on the main page (should be smaller than {@link SearchModule#getLimit()})
     * @return Max number of results on the main view
     */
    public int getMinLimit();
    
    /**
     * Get the module order, smaller order means that it is displayed before
     * @return The module order value
     */
    public int getOrder();
}
