/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tags;

import javax.jcr.Node;

import org.ametys.cms.tag.jcr.TagFactory;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;

/**
 * {@link AmetysObjectFactory} for creating {@link ProjectTagJCR}.
 */
public class ProjectTagFactory extends TagFactory
{
    /** JCR nodetype for resources collection */
    @SuppressWarnings("hiding")
    public static final String TAG_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":project-tag";
    
    
    @Override
    public ProjectTagJCR getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new ProjectTagJCR(node, parentPath, this);
    }
}
