/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Date;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.threads.actions.ThreadDAO;
import org.ametys.plugins.explorer.threads.jcr.JCRPost;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.documents.ResourceCreatedOrUpdatedActivityType;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class DocumentCommentedActivityType
extends ResourceCreatedOrUpdatedActivityType {
    public static final String LAST_MODIFIED = "lastModified";
    public static final String LAST_CONTRIBUTOR = "lastContributor";
    public static final String COMMENT_SUMMARY = "commentSummary";
    private ThreadDAO _threadDAO;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._threadDAO = (ThreadDAO)serviceManager.lookup(ThreadDAO.ROLE);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        String resourceId = (String)parameters.get("object.id");
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        activity.setValue(LAST_CONTRIBUTOR, (Object)resource.getLastContributor(), "user");
        activity.setValue(LAST_MODIFIED, (Object)DateUtils.asZonedDateTime((Date)resource.getLastModified()), "datetime");
        JCRPost comment = (JCRPost)parameters.get("post");
        comment.getContent();
        activity.setValue(COMMENT_SUMMARY, (Object)StringUtils.abbreviate((String)this._threadDAO.convertPostToString(comment), (String)"\u2026", (int)150));
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        return false;
    }
}

