/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.ComplexRepositoryElementType;
import org.ametys.plugins.workspaces.activities.documents.AbstractResourceReferenceElementType;
import org.apache.commons.lang3.StringUtils;

public class ResourceReferenceRepositoryElementType
extends AbstractResourceReferenceElementType
implements ComplexRepositoryElementType<AbstractResourceReferenceElementType.ResourceReference> {
    private static final String RESOURCE_REFERENCE_NODETYPE = "ametys:resourceReference";

    public String getRepositoryDataType() {
        return RESOURCE_REFERENCE_NODETYPE;
    }

    public boolean isSingleValueEmpty(RepositoryData singleValueData) {
        return this._isStringValueEmpty(singleValueData, "id") || this._isStringValueEmpty(singleValueData, "name") || this._isStringValueEmpty(singleValueData, "mimeType");
    }

    private boolean _isStringValueEmpty(RepositoryData referenceData, String name) {
        return !referenceData.hasValue(name) || StringUtils.isEmpty((CharSequence)referenceData.getString(name));
    }

    public AbstractResourceReferenceElementType.ResourceReference readSingleValue(RepositoryData singleValueData) {
        String id = singleValueData.getString("id");
        String name = singleValueData.getString("name");
        String oldName = null;
        if (singleValueData.hasValue("oldName")) {
            oldName = singleValueData.getString("oldName");
        }
        String mimeType = singleValueData.getString("mimeType");
        String version = null;
        if (singleValueData.hasValue("version")) {
            version = singleValueData.getString("version");
        }
        return new AbstractResourceReferenceElementType.ResourceReference(id, name, oldName, mimeType, version);
    }

    public void writeSingleValue(ModifiableRepositoryData parentData, String name, AbstractResourceReferenceElementType.ResourceReference value) {
        if (value != null) {
            ModifiableRepositoryData referenceData = parentData.addRepositoryData(name, this.getRepositoryDataType());
            referenceData.setValue("id", value.id());
            referenceData.setValue("name", value.name());
            String oldName = value.oldName();
            if (oldName != null) {
                referenceData.setValue("oldName", value.oldName());
            }
            referenceData.setValue("mimeType", value.mimeType());
            String baseVersionName = value.baseVersionName();
            if (baseVersionName != null) {
                referenceData.setValue("version", baseVersionName);
            }
        }
    }
}

