/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.workspaces.activities.projects.AbstractProjectsActivityType;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MemberAddedActivityType
extends AbstractProjectsActivityType {
    public static final String MEMBER_TYPE = "memberType";
    public static final String MEMBER = "member";
    private GroupManager _groupManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._groupManager = (GroupManager)serviceManager.lookup(GroupManager.ROLE);
    }

    public boolean support(Event event) {
        return (Boolean)Config.getInstance().getValue("workspaces.member.added.send.notification", true, (Object)false) != false && this._isNewUser(event);
    }

    private boolean _isNewUser(Event event) {
        Map args = event.getArguments();
        Project project = this.getProjectFromEvent(event);
        JCRProjectMember member = (JCRProjectMember)((Object)args.get("project.member"));
        return !JCRProjectMember.MemberType.USER.equals((Object)member.getType()) || !this._userIsPartOfProjectGroups(member.getUser(), project);
    }

    private boolean _userIsPartOfProjectGroups(UserIdentity identity, Project project) {
        boolean alreadyPresent = this._projectMemberManager.getProjectMembers(project, false).stream().map(ProjectMemberManager.ProjectMember::getGroup).filter(Objects::nonNull).map(Group::getUsers).anyMatch(users -> users.contains(identity));
        return alreadyPresent;
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        JCRProjectMember member = (JCRProjectMember)((Object)parameters.get("project.member"));
        member = (JCRProjectMember)this._resolver.resolveById(member.getId());
        activity.setValue(MEMBER, (Object)(JCRProjectMember.MemberType.GROUP == member.getType() ? GroupIdentity.groupIdentityToString((GroupIdentity)member.getGroup()) : UserIdentity.userIdentityToString((UserIdentity)member.getUser())));
        activity.setValue(MEMBER_TYPE, (Object)member.getType().name().toLowerCase());
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        String type;
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String memberIdentity = (String)activity.getValue(MEMBER);
        String string = type = activity.hasValue(MEMBER_TYPE) ? (String)activity.getValue(MEMBER_TYPE) : JCRProjectMember.MemberType.USER.name();
        if (JCRProjectMember.MemberType.GROUP == JCRProjectMember.MemberType.valueOf(type.toUpperCase())) {
            GroupIdentity groupIdentity = GroupIdentity.stringToGroupIdentity((String)memberIdentity);
            Group group = this._groupManager.getGroup(groupIdentity);
            json.put(MEMBER, group != null ? group.getLabel() : memberIdentity);
        } else if (JCRProjectMember.MemberType.USER == JCRProjectMember.MemberType.valueOf(type.toUpperCase())) {
            UserIdentity userIdentity = UserIdentity.stringToUserIdentity((String)memberIdentity);
            User user = this._userManager.getUser(userIdentity);
            json.put(MEMBER, user != null ? user.getFullName() : (userIdentity != null ? userIdentity.getLogin() : memberIdentity));
        }
        json.put("identity", memberIdentity);
        return json;
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        return null;
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        HashMap members = new HashMap();
        for (Activity activity : activities) {
            Map json;
            String identity;
            if (!activity.hasValue(MEMBER) || members.containsKey(identity = (String)(json = activity.toJSONForClient()).get("identity"))) continue;
            HashMap m = new HashMap();
            m.put("name", json.get(MEMBER));
            m.put("type", json.get(MEMBER_TYPE));
            m.put("identity", identity);
            members.put(identity, m);
        }
        mergedActivities.put("members", members.values());
        return mergedActivities;
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        return (Project)((Object)args.get("project"));
    }
}

