/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.events;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.workspaces.calendars.AbstractCalendarDAO;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarDAO;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class CalendarEventJSONHelper
extends AbstractCalendarDAO {
    public static final String ROLE = CalendarEventJSONHelper.class.getName();
    private static final String __HOUR_PATTERN = "yyyyMMdd'T'HHmmssXXX";
    protected CalendarDAO _calendarDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._calendarDAO = (CalendarDAO)((Object)manager.lookup(CalendarDAO.ROLE));
    }

    public Map<String, Object> eventAsJsonWithOccurrence(CalendarEvent event, ZonedDateTime occurrenceDate, boolean fullInfo) {
        Map<String, Object> eventData = this.eventAsJson(event, fullInfo, false);
        Optional<CalendarEventOccurrence> optionalEvent = event.getFirstOccurrence(occurrenceDate);
        if (optionalEvent.isPresent()) {
            eventData.putAll(optionalEvent.get().toJSON());
        }
        return eventData;
    }

    public Map<String, Object> eventAsJsonWithOccurrences(CalendarEvent event, boolean fullInfo, ZonedDateTime startDate, ZonedDateTime endDate) {
        Map<String, Object> eventData = this.eventAsJson(event, false, false);
        List<CalendarEventOccurrence> occurences = event.getOccurrences(startDate, endDate);
        ArrayList<Map<String, Object>> occurrencesDataList = new ArrayList<Map<String, Object>>();
        eventData.put("occurrences", occurrencesDataList);
        for (CalendarEventOccurrence occurence : occurences) {
            occurrencesDataList.add(occurence.toJSON());
        }
        return eventData;
    }

    public Map<String, Object> eventAsJson(CalendarEvent event, boolean fullInfo, boolean useICSFormat) {
        Calendar calendar = (Calendar)event.getParent();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", event.getId());
        result.put("calendarId", event.getParent().getId());
        result.put("color", calendar.getColor());
        result.put("title", event.getTitle());
        result.put("description", event.getDescription());
        boolean fullDay = event.getFullDay();
        result.put("fullDay", fullDay);
        result.put("recurrenceType", event.getRecurrenceType().toString());
        result.put("location", event.getLocation());
        result.put("keywords", event.getTags());
        ZonedDateTime untilDate = event.getRepeatUntil();
        if (untilDate != null) {
            if (useICSFormat) {
                untilDate = untilDate.plusDays(1L).minusSeconds(1L);
            }
            result.put("untilDate", this.formatDate(untilDate, useICSFormat, fullDay));
        }
        ZonedDateTime startDateEvent = event.getStartDate();
        ZonedDateTime endDateEvent = event.getEndDate();
        if (event.getFullDay().booleanValue()) {
            result.put("endDateNextDay", this.formatDate(endDateEvent.plusDays(1L), useICSFormat, fullDay));
        }
        result.put("startDate", this.formatDate(startDateEvent, useICSFormat, fullDay));
        if (event.getFullDay().booleanValue() && useICSFormat) {
            result.put("endDate", this.formatDate(endDateEvent.plusDays(1L), useICSFormat, fullDay));
        } else {
            result.put("endDate", this.formatDate(endDateEvent, useICSFormat, fullDay));
        }
        List<ZonedDateTime> excludedOccurences = event.getExcludedOccurences();
        if (excludedOccurences != null && !excludedOccurences.isEmpty()) {
            ArrayList<String> excludedOccurencesStrings = new ArrayList<String>();
            for (ZonedDateTime excludedOccurence : excludedOccurences) {
                excludedOccurencesStrings.add(this.formatDate(excludedOccurence, useICSFormat, true));
            }
            result.put("excludedDates", excludedOccurencesStrings);
        }
        UserIdentity creatorIdentity = event.getCreator();
        User creator = this._userManager.getUser(creatorIdentity);
        result.put("creator", creatorIdentity);
        result.put("creatorFullName", creator != null ? creator.getFullName() : creatorIdentity.getLogin());
        UserIdentity user = this._currentUserProvider.getUser();
        result.put("isCreator", creatorIdentity.equals((Object)user));
        result.put("creationDate", this.formatDate(event.getCreationDate(), useICSFormat, false));
        UserIdentity contributorIdentity = event.getLastContributor();
        User contributor = this._userManager.getUser(contributorIdentity);
        result.put("contributor", contributorIdentity);
        result.put("contributorFullName", contributor != null ? contributor.getFullName() : contributorIdentity.getLogin());
        result.put("lastModified", this.formatDate(event.getLastModified(), useICSFormat, false));
        if (fullInfo) {
            result.putAll(this._eventAsJsonFullInfo(event));
        }
        result.put("calendar", this._calendarDAO.getCalendarProperties(calendar));
        result.put("tags", event.getTags());
        String location = StringUtils.defaultString((String)event.getLocation());
        result.put("location", location);
        result.put("places", Stream.of(location.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
        result.put("rights", this._extractEventRightData(event));
        result.put("resourceIds", event.getResources());
        return result;
    }

    private String formatDate(ZonedDateTime date, boolean useICSFormat, boolean fullDay) {
        if (useICSFormat) {
            if (fullDay) {
                return DateUtils.zonedDateTimeToString((ZonedDateTime)date);
            }
            return DateUtils.zonedDateTimeToString((ZonedDateTime)date, (ZoneId)date.getZone(), (String)__HOUR_PATTERN);
        }
        return DateUtils.zonedDateTimeToString((ZonedDateTime)date);
    }

    protected Map<String, Object> _eventAsJsonFullInfo(CalendarEvent event) {
        ExplorerNode explorerNode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ExplorerNode root = explorerNode = (ExplorerNode)event.getParent();
        while (root.getParent() instanceof ExplorerNode) {
            root = (ExplorerNode)root.getParent();
        }
        result.put("rootId", root.getId());
        result.put("parentId", explorerNode.getId());
        result.put("name", event.getName());
        result.put("path", explorerNode.getExplorerPath());
        result.put("isModifiable", true);
        result.put("rights", this._getUserRights(explorerNode));
        return result;
    }

    protected Map<String, Object> _extractEventRightData(CalendarEvent event) {
        Calendar calendar;
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Edit", (Object)(calendar = (Calendar)event.getParent())) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugins_Workspaces_Event_Delete", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete-own", this._rightManager.hasRight(user, "Plugins_Workspaces_Owned_Event_Delete", (Object)calendar) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    protected Set<String> _getUserRights(ExplorerNode node) {
        return this._rightManager.getUserRights(this._currentUserProvider.getUser(), (Object)node);
    }
}

