/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.events;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;

public class CalendarEventOccurrence {
    private ZonedDateTime _startDate;
    private ZonedDateTime _endDate;
    private boolean _isFullDay;
    private List<String> _resourceIds;
    private CalendarEvent _event;

    public CalendarEventOccurrence(CalendarEvent calendarEvent, ZonedDateTime occurrenceDate) {
        this._startDate = occurrenceDate;
        long diffInSeconds = ChronoUnit.SECONDS.between(calendarEvent.getStartDate(), calendarEvent.getEndDate());
        this._endDate = occurrenceDate.plusSeconds(diffInSeconds);
        this._isFullDay = calendarEvent.getFullDay();
        this._resourceIds = calendarEvent.getResources();
        this._event = calendarEvent;
    }

    public ZonedDateTime getStartDate() {
        return this._startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this._startDate = startDate;
    }

    public ZonedDateTime getEndDate() {
        return this._endDate;
    }

    public void setEndDate(ZonedDateTime endDate) {
        this._endDate = endDate;
    }

    public boolean isFullDay() {
        return this._isFullDay;
    }

    public void setFullDay(boolean isFullDay) {
        this._isFullDay = isFullDay;
    }

    public List<String> getResourceIds() {
        return this._resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this._resourceIds = resourceIds;
    }

    public boolean before(ZonedDateTime date) {
        return this.getStartDate().isBefore(date);
    }

    public boolean after(ZonedDateTime date) {
        return this.getStartDate().isAfter(date);
    }

    public CalendarEvent getEvent() {
        return this._event;
    }

    public Map<String, Object> toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String occurrenceDateIso = DateUtils.zonedDateTimeToString((ZonedDateTime)this._startDate);
        result.put("id", this._event.getId() + "$" + occurrenceDateIso);
        result.put("occurrenceDate", occurrenceDateIso);
        ZonedDateTime startDateEvent = this._startDate;
        ZonedDateTime endDateEvent = this._endDate;
        if (this._isFullDay) {
            result.put("endDateNextDay", DateUtils.zonedDateTimeToString((ZonedDateTime)endDateEvent.plusDays(1L)));
        }
        result.put("startDate", DateUtils.zonedDateTimeToString((ZonedDateTime)startDateEvent));
        result.put("endDate", DateUtils.zonedDateTimeToString((ZonedDateTime)endDateEvent));
        return result;
    }
}

