/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryColorsComponent;
import org.ametys.plugins.workspaces.categories.CategoryJCRProvider;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class CategoryHelper
implements Serviceable,
Component {
    public static final String ROLE = CategoryHelper.class.getName();
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private CategoryJCRProvider _jcrCategoryProvider;
    private CategoryColorsComponent _categoryColorsComponent;

    public void service(ServiceManager smanager) throws ServiceException {
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._jcrCategoryProvider = (CategoryJCRProvider)((Object)this._categoryProviderEP.getExtension(CategoryJCRProvider.class.getName()));
        this._categoryColorsComponent = (CategoryColorsComponent)((Object)smanager.lookup(CategoryColorsComponent.ROLE));
    }

    public Collection<Category> getRootCategories() {
        return this._jcrCategoryProvider.getTags(Collections.EMPTY_MAP).values();
    }

    public Collection<Category> getLeafCategories() {
        Collection<Category> rootCategories = this.getRootCategories();
        ArrayList<Category> leafCategories = new ArrayList<Category>();
        for (Category category : rootCategories) {
            leafCategories.addAll(this.getLeafCategories(category));
        }
        return leafCategories;
    }

    public Collection<Category> getLeafCategories(Category category) {
        Map<String, Category> childTags = category.getTags();
        if (childTags.isEmpty()) {
            return Collections.singletonList(category);
        }
        ArrayList<Category> leafCategories = new ArrayList<Category>();
        for (Category childCategory : childTags.values()) {
            leafCategories.addAll(this.getLeafCategories(childCategory));
        }
        return leafCategories;
    }

    public Collection<Category> getChildCategories(Category category) {
        ArrayList<Category> childCategories = new ArrayList<Category>();
        for (Category childCategory : category.getTags().values()) {
            childCategories.add(childCategory);
            childCategories.addAll(this.getChildCategories(childCategory));
        }
        return childCategories;
    }

    public Map<String, String> getCategoryColor(Category category) {
        Category categoryForColor;
        for (categoryForColor = category; categoryForColor != null && categoryForColor.getColor(false) == null; categoryForColor = categoryForColor.getParent()) {
        }
        String colorIndex = (String)StringUtils.defaultIfBlank((CharSequence)(categoryForColor != null ? categoryForColor.getColor(false) : ""), (CharSequence)this._categoryColorsComponent.getDefaultKey());
        Map color = (Map)this._categoryColorsComponent.getColors().get(colorIndex);
        if (color == null) {
            color = (Map)this._categoryColorsComponent.getColors().get(this._categoryColorsComponent.getDefaultKey());
        }
        return color;
    }
}

