/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.core.ui.Callable;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.workspaces.forum.AbstractWorkspaceThreadDAO;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WorkspaceThreadUserPreferencesDAO
extends AbstractWorkspaceThreadDAO {
    public static final String ROLE = WorkspaceThreadUserPreferencesDAO.class.getName();
    public static final String LAST_THREAD_READ_USER_PREF_CONTEXT = "/workspaces/forum";
    protected UserPreferencesManager _userPrefsManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userPrefsManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
    }

    @Callable
    public void clearUnopenedThreadNotification(String threadId) {
        this._setDate(threadId, DateUtils.dateToString((Date)new Date()));
    }

    @Callable
    public void clearUnreadCommentsNotification(String threadId, String commentId) {
        JCRThread thread = this._getThreadByID(threadId);
        RichTextComment comment = (RichTextComment)thread.getComment(commentId);
        this._setDate(threadId, comment.getCreationDate().toString());
    }

    private void _setDate(String threadId, String dateAsString) {
        try {
            this._userPrefsManager.addUserPreference(this._currentUserProvider.getUser(), LAST_THREAD_READ_USER_PREF_CONTEXT, Map.of(), threadId, dateAsString);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occured while setting the user preferences.", (Throwable)e);
        }
    }

    public boolean hasNotification(Thread thread) {
        ZonedDateTime lastReadDate = this.getLastReadDate(thread);
        return lastReadDate == null || lastReadDate.isBefore(thread.getLastContribution());
    }

    public boolean hasOpenedThread(Thread thread) {
        ZonedDateTime lastReadDate = this.getLastReadDate(thread);
        return lastReadDate != null && lastReadDate.isAfter(thread.getCreationDate());
    }

    public long getUnreadCommentNumber(Thread thread) {
        ZonedDateTime lastReadDate = this.getLastReadDate(thread);
        if (lastReadDate != null) {
            return thread.getFlattenComments(true, true).stream().filter(comment -> comment.getCreationDate().isAfter(lastReadDate)).count();
        }
        return 0L;
    }

    public ZonedDateTime getLastReadDate(Thread thread) {
        Date lastReadDate = null;
        try {
            lastReadDate = this._userPrefsManager.getUserPreferenceAsDate(this._currentUserProvider.getUser(), LAST_THREAD_READ_USER_PREF_CONTEXT, Map.of(), thread.getId());
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occured while getting the user preferences.", (Throwable)e);
        }
        ZonedDateTime lastReadDateAsZonedDateTime = DateUtils.asZonedDateTime(lastReadDate);
        return lastReadDateAsZonedDateTime;
    }
}

