/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members.observers;

import java.util.List;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.workspaces.members.observers.AbstractMemberObserver;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnMemberUpdatedObserver
extends AbstractMemberObserver {
    private CacheInvalidationPolicy _cachePolicy;
    private UserDirectoryPageHandler _udPageHandler;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cachePolicy = (CacheInvalidationPolicy)smanager.lookup(CacheInvalidationPolicy.class.getName());
        this._udPageHandler = (UserDirectoryPageHandler)smanager.lookup(UserDirectoryPageHandler.ROLE);
    }

    @Override
    public int getPriority(Event event) {
        return 4000;
    }

    @Override
    protected void _internalObserve(Event event, List<Content> userContents) throws Exception {
        Set rootPages = this._udPageHandler.getUserDirectoryRootPages("org.ametys.plugins.workspaces.Content.member");
        for (Content userContent : userContents) {
            for (Page rootPage : rootPages) {
                try {
                    this._cachePolicy.invalidateCacheOnContentModification(rootPage.getSite(), userContent);
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to invalidate cache for user content " + userContent, (Throwable)e);
                }
            }
        }
    }
}

