/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.rights.ContentAccessController;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ContentsCreatorAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    private static final List<String> __CREATOR_RIGHTS = List.of("Front_Edition_Access_Right", "Workflow_Rights_Edition_Online", "CMS_Rights_DeleteContent", "Workflow_Rights_Validate");
    protected ContentTypesHelper _cTypeHelper;
    protected ProjectRightHelper _projectRightHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._cTypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._projectRightHelper = (ProjectRightHelper)((Object)smanager.lookup(ProjectRightHelper.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean isSupported(Object object) {
        if (object instanceof Content) {
            Content content = (Content)object;
            HashSet<String> supportedCTypes = new HashSet<String>(this._projectRightHelper.getProjectContentTypesAndModules().keySet());
            supportedCTypes.add("org.ametys.plugins.workspaces.Content.catalogNews");
            for (String contentTypeId : supportedCTypes) {
                if (!this._cTypeHelper.isInstanceOf(content, contentTypeId)) continue;
                return true;
            }
        }
        return false;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (((Content)object).getCreator().equals((Object)user)) {
            return __CREATOR_RIGHTS.contains(rightId) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (((Content)object).getCreator().equals((Object)user)) {
            for (String rightId : __CREATOR_RIGHTS) {
                permissionByRight.put(rightId, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (__CREATOR_RIGHTS.contains(rightId)) {
            permissionByUser.put(((Content)object).getCreator(), AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public AccessExplanation getStandardAccessExplanation(AccessController.AccessResult permission, Object object) {
        switch (permission) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), permission, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CATALOG_CONTENT_CREATOR_ACCESS_CONTROLLER_" + permission.name() + "_EXPLANATION", Map.of("title", this.getObjectLabel(object))));
            }
        }
        return super.getStandardAccessExplanation(permission, object);
    }

    public I18nizableText getObjectCategory(Object object) {
        return ContentAccessController.CONTENT_CONTEXT_CATEGORY;
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Content) {
            Content content = (Content)object;
            return new I18nizableText(content.getTitle());
        }
        throw new RightsException("unsupported context: " + object.toString());
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        if (StringUtils.isNotBlank((CharSequence)siteName)) {
            ArrayList<String> supportedCTypes = new ArrayList<String>(this._projectRightHelper.getProjectContentTypesAndModules().keySet());
            supportedCTypes.add("org.ametys.plugins.workspaces.Content.catalogNews");
            ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, (String[])supportedCTypes.toArray(String[]::new));
            StringExpression siteExpression = new StringExpression("site", Expression.Operator.EQ, siteName);
            UserExpression creatorExpr = new UserExpression("creator", Expression.Operator.EQ, identity);
            return this._resolver.query(ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{siteExpression, cTypeExpr, creatorExpr})));
        }
        return List.of();
    }

    protected Collection<String> getHandledRights(UserIdentity identity, Set<GroupIdentity> groups, Object object) {
        return __CREATOR_RIGHTS;
    }
}

