/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.workspaces.html.HTMLTransformer;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.plugins.workspaces.tasks.AbstractWorkspaceTaskDAO;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.plugins.workspaces.tasks.WorkspaceTasksListDAO;
import org.ametys.plugins.workspaces.tasks.jcr.JCRTask;
import org.ametys.plugins.workspaces.tasks.json.TaskJSONHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;

public class WorkspaceTaskDAO
extends AbstractWorkspaceTaskDAO {
    public static final String ROLE = WorkspaceTaskDAO.class.getName();
    protected HTMLTransformer _htmlTransformer;
    protected ProjectMemberManager _projectMemberManager;
    protected ProjectTagProviderExtensionPoint _tagProviderExtPt;
    protected TaskJSONHelper _taskJSONHelper;
    protected WorkspaceTasksListDAO _workspaceTasksListDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._htmlTransformer = (HTMLTransformer)((Object)manager.lookup(HTMLTransformer.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._tagProviderExtPt = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._taskJSONHelper = (TaskJSONHelper)((Object)manager.lookup(TaskJSONHelper.ROLE));
        this._workspaceTasksListDAO = (WorkspaceTasksListDAO)((Object)manager.lookup(WorkspaceTasksListDAO.ROLE));
    }

    @Callable
    public List<Map<String, Object>> getTasks() throws IllegalAccessException {
        String projectName = this._getProjectName();
        ModifiableResourceCollection moduleRoot = this._getModuleRoot(projectName);
        if (!this._rightManager.currentUserHasReadAccess((Object)moduleRoot)) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to get tasks without reader right");
        }
        ArrayList<Map<String, Object>> tasksInfo = new ArrayList<Map<String, Object>>();
        Project project = this._projectManager.getProject(projectName);
        for (Task task : this.getProjectTasks(project)) {
            tasksInfo.add(this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName()));
        }
        return tasksInfo;
    }

    @Callable
    public Map<String, Object> addTask(String tasksListId, Map<String, Object> parameters, List<Part> newFiles, List<String> newFileNames) throws IllegalAccessException {
        String projectName = this._getProjectName();
        if (StringUtils.isBlank((CharSequence)tasksListId)) {
            throw new IllegalArgumentException("Tasks list id is mandatory to create a new task");
        }
        ModifiableTraversableAmetysObject tasksRoot = this._getTasksRoot(projectName);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Handle_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to add task without convenient right [Plugin_Workspace_Handle_Task]");
        }
        int index = 1;
        Object name = "task-1";
        while (tasksRoot.hasChild((String)name)) {
            name = "task-" + ++index;
        }
        JCRTask task = (JCRTask)tasksRoot.createChild((String)name, "ametys:task");
        task.setTasksListId(tasksListId);
        task.setPosition(Long.valueOf(this._workspaceTasksListDAO.getChildTask(tasksListId).size()));
        ZonedDateTime now = ZonedDateTime.now();
        task.setCreationDate(now);
        task.setLastModified(now);
        task.setAuthor(this._currentUserProvider.getUser());
        Map<String, Object> attributesResults = this._setTaskAttributes(task, parameters, newFiles, newFileNames, new ArrayList<String>());
        tasksRoot.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("task", task);
        eventParams.put("object.id", task.getId());
        this._observationManager.notify(new Event("task.created", this._currentUserProvider.getUser(), eventParams));
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("task", this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName()));
        results.putAll(attributesResults);
        return results;
    }

    @Callable
    public Map<String, Object> editTask(String taskId, Map<String, Object> parameters, List<Part> newFiles, List<String> newFileNames, List<String> deleteFiles) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof JCRTask)) {
            throw new IllegalClassException(JCRTask.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Handle_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to edit task without convenient right [Plugin_Workspace_Handle_Task]");
        }
        JCRTask task = (JCRTask)object;
        Map<String, Object> attributesResults = this._setTaskAttributes(task, parameters, newFiles, newFileNames, deleteFiles);
        ZonedDateTime now = ZonedDateTime.now();
        task.setLastModified(now);
        task.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("task", task);
        eventParams.put("object.id", taskId);
        this._observationManager.notify(new Event("task.updated", this._currentUserProvider.getUser(), eventParams));
        if (attributesResults.containsKey("isClosed")) {
            this._observationManager.notify(new Event("task.closed.status.changed", this._currentUserProvider.getUser(), eventParams));
        }
        if (attributesResults.containsKey("changedAssignments")) {
            this._observationManager.notify(new Event("task.assigned", this._currentUserProvider.getUser(), eventParams));
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("task", this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName()));
        results.putAll(attributesResults);
        return results;
    }

    @Callable
    public Map<String, Object> moveTask(String tasksListId, String taskId, long newPosition) throws IllegalAccessException {
        List<Task> childTasks;
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Handle_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to move task without convenient right [Plugin_Workspace_Handle_Task]");
        }
        Task task = (Task)object;
        if (tasksListId != task.getTaskListId()) {
            childTasks = this._workspaceTasksListDAO.getChildTask(task.getTaskListId());
            long position = 0L;
            for (Task childTask : childTasks) {
                if (childTask.getId().equals(taskId)) continue;
                childTask.setPosition(position);
                ++position;
            }
        }
        task.setTasksListId(tasksListId);
        childTasks = this._workspaceTasksListDAO.getChildTask(tasksListId);
        int size = childTasks.size();
        if (newPosition > (long)size) {
            throw new IllegalArgumentException("New position (" + newPosition + ") can't be greater than tasks child size (" + size + ")");
        }
        long position = 0L;
        task.setPosition(newPosition);
        for (Task childTask : childTasks) {
            if (position == newPosition) {
                ++position;
            }
            if (childTask.getId().equals(taskId)) {
                childTask.setPosition(newPosition);
                continue;
            }
            childTask.setPosition(position);
            ++position;
        }
        tasksRoot.saveChanges();
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    @Callable
    public Map<String, Object> deleteTask(String taskId) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Delete_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to delete task without convenient right [Plugin_Workspace_Delete_Task]");
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        Task jcrTask = (Task)object;
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("task", jcrTask);
        eventParams.put("object.id", taskId);
        this._observationManager.notify(new Event("task.deleting", this._currentUserProvider.getUser(), eventParams));
        String tasksListId = jcrTask.getTaskListId();
        jcrTask.remove();
        long position = 0L;
        for (Task childTask : this._workspaceTasksListDAO.getChildTask(tasksListId)) {
            childTask.setPosition(position);
            ++position;
        }
        tasksRoot.saveChanges();
        eventParams = new HashMap();
        eventParams.put("object.id", taskId);
        this._observationManager.notify(new Event("task.deleted", this._currentUserProvider.getUser(), eventParams));
        return results;
    }

    @Callable
    public Map<String, Object> commentTask(String taskId, String commentText) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Comment_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to comment task without convenient right [Plugin_Workspace_Comment_Task]");
        }
        Task task = (Task)object;
        this.createComment(task, commentText, tasksRoot);
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    @Callable
    public Map<String, Object> editCommentTask(String taskId, String commentId, String commentText) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Comment_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to edit task without convenient right [Plugin_Workspace_Comment_Task]");
        }
        Task task = (Task)object;
        this.editComment(task, commentId, commentText, tasksRoot);
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    @Callable
    public Map<String, Object> answerCommentTask(String taskId, String commentId, String commentText) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Comment_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to comment task without convenient right [Plugin_Workspace_Comment_Task]");
        }
        Task task = (Task)object;
        this.answerComment(task, commentId, commentText, tasksRoot);
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    @Callable
    public Map<String, Object> deleteCommentTask(String taskId, String commentId) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = this._userManager.getUser(userIdentity);
        Task task = (Task)object;
        Comment comment = (Comment)task.getComment(commentId);
        String authorEmail = comment.getAuthorEmail();
        if (!authorEmail.equals(user.getEmail()) && this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Comment_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + userIdentity + "' tried to delete an other user's comment task");
        }
        this.deleteComment(task, commentId, tasksRoot);
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    @Callable
    public Map<String, Object> likeOrUnlikeCommentTask(String taskId, String commentId, Boolean liked) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(taskId);
        if (!(object instanceof Task)) {
            throw new IllegalClassException(Task.class, object.getClass());
        }
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)object.getParent();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Workspace_Comment_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to react a comment task without convenient right [Plugin_Workspace_Comment_Task]");
        }
        Task task = (Task)object;
        this.likeOrUnlikeComment(task, commentId, liked, tasksRoot);
        return this._taskJSONHelper.taskAsJSON(task, this._getSitemapLanguage(), this._getSiteName());
    }

    protected Map<String, Object> _setTaskAttributes(JCRTask task, Map<String, Object> parameters, List<Part> newFiles, List<String> newFileNames, List<String> deleteFiles) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        String label = (String)parameters.get("label");
        task.setLabel(label);
        String description = (String)parameters.get("description");
        task.setDescription(description);
        this._setTaskDates(task, parameters);
        this._setTaskCloseInfo(task, parameters, results);
        this._setAttachments(task, newFiles, newFileNames, deleteFiles);
        List assignmentIds = parameters.getOrDefault("assignments", new ArrayList());
        List<UserIdentity> users = assignmentIds.stream().map(m -> (String)m.get("id")).map(UserIdentity::stringToUserIdentity).collect(Collectors.toList());
        if (!task.getAssignments().equals(users)) {
            task.setAssignments(users);
            results.put("changedAssignments", true);
        }
        List checkListItems = parameters.getOrDefault("checkList", new ArrayList());
        List<Task.CheckItem> checkItems = checkListItems.stream().map(e -> new Task.CheckItem((String)e.get("label"), (Boolean)e.get("isChecked"))).collect(Collectors.toList());
        task.setCheckListItem(checkItems);
        List tags = parameters.getOrDefault("tags", new ArrayList());
        List<Map<String, Object>> createdTagsJson = this._handleTags(task, tags);
        results.put("newTags", createdTagsJson);
        return results;
    }

    private void _setTaskDates(JCRTask task, Map<String, Object> parameters) {
        String startDateAsStr = (String)parameters.get("startDate");
        LocalDate startDate = Optional.ofNullable(startDateAsStr).map(date -> LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE)).orElse(null);
        task.setStartDate(startDate);
        String dueDateAsStr = (String)parameters.get("dueDate");
        LocalDate dueDate = Optional.ofNullable(dueDateAsStr).map(date -> LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE)).orElse(null);
        task.setDueDate(dueDate);
    }

    private void _setTaskCloseInfo(JCRTask task, Map<String, Object> parameters, Map<String, Object> results) {
        Map closeInfo = (Map)parameters.get("closeInfo");
        if (closeInfo != null && !task.isClosed()) {
            task.close(true);
            task.setCloseAuthor(this._currentUserProvider.getUser());
            task.setCloseDate(LocalDate.now());
            results.put("isClosed", true);
        } else if (closeInfo == null && task.isClosed()) {
            task.close(false);
            task.setCloseAuthor(null);
            task.setCloseDate(null);
            results.put("isClosed", false);
        }
    }

    public List<Task> getProjectTasks(Project project) {
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        DefaultTraversableAmetysObject tasksRoot = taskModule.getTasksRoot(project, true);
        return tasksRoot.getChildren().stream().filter(Task.class::isInstance).map(Task.class::cast).collect(Collectors.toList());
    }

    public Long getTasksCount(Project project) {
        return this.getProjectTasks(project).size();
    }

    @Callable
    public Map<String, Object> getProjectMembers() throws IllegalAccessException, AmetysRepositoryException {
        String projectName = this._getProjectName();
        String lang = this._getSitemapLanguage();
        return this._projectMemberManager.getProjectMembers(projectName, lang, true);
    }
}

