/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.wall.observers;

import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.wall.WallContentModule;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractInvalidateZoneItemCacheOnWallObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected ContentTypesHelper _contentTypeHelper;
    protected PageElementCache _zoneItemCache;
    protected ProjectManager _projectManager;
    protected WorkspaceModuleExtensionPoint _moduleManagerEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._zoneItemCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public int getPriority(Event event) {
        return 3500;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String siteName;
        Optional<Project> optProject;
        Content content = (Content)event.getArguments().get("content");
        if (content instanceof WebContent && (optProject = this._projectManager.getProjectsForSite(siteName = ((WebContent)content).getSiteName()).stream().findFirst().map(p -> this._projectManager.getProject((String)p))).isPresent()) {
            Page page;
            Optional<ZoneItem> optZoneItem;
            Optional<Page> optPage;
            Project project = optProject.get();
            Object module = this._moduleManagerEP.getModule(WallContentModule.WALLCONTENT_MODULE_ID);
            if (module != null && this._projectManager.isModuleActivated(project, WallContentModule.WALLCONTENT_MODULE_ID) && (optPage = this._projectManager.getModulePages(project, (WorkspaceModule)module).stream().filter(p -> p.getSitemapName().equals(content.getLanguage())).findFirst()).isPresent() && (optZoneItem = (page = optPage.get()).getZone("default").getZoneItems().stream().filter(z -> z.getType() == ZoneItem.ZoneType.SERVICE && z.getServiceId().equals("org.ametys.web.service.SearchService")).findFirst()).isPresent()) {
                ZoneItem zoneItem = optZoneItem.get();
                this._zoneItemCache.removeItem(null, siteName, "SERVICE:" + zoneItem.getServiceId(), zoneItem.getId());
            }
        }
    }
}

