/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.type.AbstractRichTextElementType;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class InitContentFunction
extends AbstractContentWorkflowComponent
implements EnhancedFunction {
    private static final String __RICHTEXT_ATTRIBUTE_KEY = "attribute";
    private static final String __RICHTEXT_VALUE_KEY = "value";
    private static final String __RICHTEXT_IS_I18N_KEY = "isI18n";
    private static final String __RICHTEXT_I18N_CATALOG_KEY = "i18nCatalogue";
    private static final String __RICHTEXT_ACTIVATE_COMMENTS_KEY = "activateComments";
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        this._logger.info("Performing content initialisation");
        try {
            boolean activeComments;
            String value;
            WorkflowAwareContent content = this.getContent(transientVars);
            String attributePath = (String)args.get(__RICHTEXT_ATTRIBUTE_KEY);
            if (StringUtils.isEmpty((CharSequence)attributePath)) {
                attributePath = "content";
            }
            boolean isI18N = "true".equals(args.get(__RICHTEXT_IS_I18N_KEY));
            String i18nCatalogue = (String)args.get(__RICHTEXT_I18N_CATALOG_KEY);
            if (StringUtils.isEmpty((CharSequence)i18nCatalogue)) {
                i18nCatalogue = "application";
            }
            if (StringUtils.isBlank((CharSequence)(value = (String)args.get(__RICHTEXT_VALUE_KEY)))) {
                this._logger.warn(String.format("Missing 'value' argument for workflow function %s, the content '%s' will not be initialized with default value", InitContentFunction.class.getName(), content.getId()));
                return;
            }
            if (!(content instanceof ModifiableContent)) {
                this._logger.warn(String.format("Content '%s' is not a modifiable content. It will not be initialized with default value", content.getId()));
                return;
            }
            String defaultValue = "";
            if (isI18N) {
                I18nizableText text = new I18nizableText(i18nCatalogue, value);
                defaultValue = this._i18nUtils.translate((I18nizable)text, content.getLanguage());
            } else {
                defaultValue = value;
            }
            if (content.hasDefinition(attributePath)) {
                ModelItemType type = content.getDefinition(attributePath).getType();
                if (type instanceof AbstractRichTextElementType) {
                    this._setRichText((ModifiableContent)content, attributePath, defaultValue);
                } else {
                    this._setText((ModifiableContent)content, attributePath, defaultValue);
                }
            }
            if ((activeComments = "true".equals(args.get(__RICHTEXT_ACTIVATE_COMMENTS_KEY))) && content.hasDefinition("comment")) {
                ((ModifiableContent)content).setValue("comment", (Object)true);
            }
            content.saveChanges();
            if (content instanceof VersionableAmetysObject) {
                ((VersionableAmetysObject)content).checkpoint();
            }
        }
        catch (IOException e) {
            throw new WorkflowException("Unable to set the rich text in the content", (Throwable)e);
        }
    }

    private void _setText(ModifiableContent content, String attributePath, String value) {
        content.setValue(attributePath, (Object)value);
    }

    private void _setRichText(ModifiableContent content, String attributePath, String value) throws IOException {
        RichText richText = new RichText();
        String docbook = this._textToDocbook(value);
        ByteArrayInputStream is = new ByteArrayInputStream(docbook.getBytes(StandardCharsets.UTF_8));
        richText.setInputStream((InputStream)is);
        richText.setEncoding("UTF-8");
        richText.setMimeType("text/xml");
        richText.setLastModificationDate(ZonedDateTime.now());
        content.setValue(attributePath, (Object)richText);
    }

    private String _textToDocbook(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<article version=\"5.0\" xmlns=\"http://docbook.org/ns/docbook\">");
        sb.append("<para>");
        sb.append(value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\r?\n", "<phrase role=\"linebreak\"/>"));
        sb.append("</para>");
        sb.append("</article>");
        return sb.toString();
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.PRE;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_INIT_CONTENT_FUNCTION_LABEL");
    }
}

