/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This is a relation handler between:
 * * source : project-tag
 * * destination : project-tag or project tag provider
 * 
 * E.g. when you drag a tag to another project-tag
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.tag.ProjectTagsRelationHandler', {
	extend: 'Ametys.plugins.cms.relations.DefaultTagsRelationHandler',
	
	_getTagRegexp: function()
	{
		return /^project-tag$/;
	},
	
	_getTagRootRegexp: function()
	{
		return /^project-tag(-root)?$/;
	},
	
	_link: function(sourceTargets, target, callback)
	{
		var sourceIds = [];
		Ext.Array.forEach(Ametys.message.MessageTargetHelper.findTargets(sourceTargets, this._getTagRegexp(), 1), function(target) {
			sourceIds.push(target.getParameters().id);
		});
		
		Ametys.plugins.cms.tag.TagHelper.move(
				target.getParameters().id, 
				sourceIds,
				"org.ametys.plugins.workspaces.tags.ProjectJCRTagsDAO",
				Ametys.message.MessageTarget.PROJECT_TAG,
				Ext.bind(this._linkCb, this, [callback], true)
		);
	}
});
