/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the JCR tags in a tree 
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.tag.tool.ProjectTagsTool', {
    extend : 'Ametys.plugins.cms.tag.tool.TagsTool',

    _tagTooltipTpl : Ext.create('Ext.XTemplate', [
                         '<tpl if="description && description != \'\'">',
                            '{description}<br/>',
                         '</tpl>'
    ]),
       
    getTagProviderId: function()
    {
    	return 'org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider';
    },
    
    getTagProviderEPId: function()
    {
    	return 'org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint';
    },
    
    getTagDAO: function()
    {
    	return 'org.ametys.plugins.workspaces.tags.ProjectJCRTagsDAO';
    },
    
    getTagModel: function()
    {
    	return 'Ametys.plugins.workspaces.project.tag.ProjectTagNode';
    },
    
    getTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_TAG;
    },
    
    getRootTagTargetMessage: function()
    {
    	return Ametys.message.MessageTarget.PROJECT_TAG_ROOT;
    },

	_getTooltip: function(node)
	{
		var title = node.get('name');
		if (node.get("title") != null)
		{
			title = node.get('title') + " (" + title + ")";
		}
		
		var text = this._tagTooltipTpl.applyTemplate ({
			description: node.get('description') 
		});
		
		return {
			title: title,
			glyphIcon: node.get('tooltipIconCls'),
			imageWidth: 48,
			imageHeight: 48,
			text: text,
			inribbon: false
		};
	},
    
	_updateAdditionalInfo : function (node, response)
    {
		//No additional info
    }
});

Ext.define("Ametys.message.ProjectTagMessageTarget",
    {
		override: "Ametys.message.MessageTarget",

	    statics: 
	    {
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_TAG The target type is a tag. The expected parameters are:
	         * @property {String} PROJECT_TAG.id The id of tag
	         * @property {String} PROJECT_TAG.parentId The id of the parent of the tag
	         * @property {String} PROJECT_TAG.name The name of tag
	         */
	        PROJECT_TAG: "project-tag",
	
	        /**
	         * @member Ametys.message.MessageTarget
	         * @readonly
	         * @property {String} PROJECT_TAG_ROOT The target type is a tag root. The expected parameters are:
	         * @property {String} PROJECT_TAG_ROOT.id The id of root tag
	         * @property {String} PROJECT_TAG_ROOT.name The name of root tag 
	         */
	        PROJECT_TAG_ROOT: "project-tag-root"
	    }
    }
);
