<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:mail="org.ametys.plugins.workspaces.project.helper.MailXSLTHelper">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:template name="title">
        <xsl:variable name="titleKey">
            <xsl:choose>
                <xsl:when test="/notification/closed = 'true'">PROJECT_MAIL_NOTIFICATION_BODY_CLOSE_<xsl:value-of select="/notification/eventKey" />_TITLE</xsl:when>
                <xsl:when test="/notification/closed = 'false'">PROJECT_MAIL_NOTIFICATION_BODY_OPEN_<xsl:value-of select="/notification/eventKey" />_TITLE</xsl:when>
                <xsl:otherwise>PROJECT_MAIL_NOTIFICATION_BODY_<xsl:value-of select="/notification/eventKey" />_TITLE</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="{$titleKey}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
    <xsl:template match="activity">
        <item type="task">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="author"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            <lastModified><xsl:value-of select="date"/></lastModified>
            <xsl:apply-templates select="." mode="attachments"/>
        </item>
    </xsl:template>

    <xsl:template match="activity" mode="title">
        <title><xsl:value-of select="taskTitle"/></title>
    </xsl:template>
    
    <xsl:template match="activity" mode="attachments">
        <xsl:copy-of select="nbAttachments"/>
    </xsl:template>
    
    <xsl:template name="section-button">
        <xsl:variable name="hasDueDate" select="mail:hasDueDate(activity/taskId)"/>
        <button>
            <text>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
            </text>
            <href>
                <xsl:call-template name="section-button-href" />
            </href>
            <width>300</width>
            <margin-bottom>
                <xsl:choose>
                    <xsl:when test="$hasDueDate != ''">10</xsl:when>
                    <xsl:otherwise>50</xsl:otherwise>
                </xsl:choose>
            </margin-bottom>
        </button>
    </xsl:template>
    
    <xsl:template name="section-button-href" >
        <xsl:choose>
            <xsl:when test="modulePageId != ''">
                <xsl:choose>
		            <xsl:when test="count(tasks/task) = 1 and /notification/eventKey != 'TASK_DELETING'">
		                <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>#task-<xsl:value-of select="tasks/task/@id" />
		            </xsl:when>
		            <xsl:otherwise>
		                <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>
		            </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="section-link">
        <xsl:variable name="hasDueDate" select="mail:hasDueDate(activity/taskId)"/>
         <xsl:variable name="icslink" select="mail:getTaskICSExportLink(activity/taskId, project/url)"/>
        
         <xsl:if test="$hasDueDate != ''">
            <link>
                <text>
                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_EXPORT_ICS_LINK_TEXT" i18n:catalogue="plugin.workspaces"/>
                </text>
                <href>
                    <xsl:value-of select="$icslink"/>
                </href>
            </link>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>