<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="view://stylesheets/mail/comment2notification.xsl"/>
    
    <!-- Override to set the i18n key -->
    <xsl:template name="title">
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_WALLCONTENT_COMMENT_VALIDATED_TITLE" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
    <xsl:template match="activity" mode="content-title">
        <!-- There is no title to a wallcontent, we use the author full name here to mimic the wall rendering -->
        <title><xsl:value-of select="contentCreator"/></title>
    </xsl:template>
</xsl:stylesheet>
