/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
const state = () => ({
    members: []
});

const getters = {};

const actions = {};

const mutations = {
    SET_MEMBRES(state, members) {
        state.members = members;
    },
    ADD_MEMBER(state, member) {
        state.members.push(member);
    }
};

export default {
    namespaced: true,
    getters,
    state,
    actions,
    mutations
};
