/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';
Vue.directive('expandable', {
  inserted: function (el, binding, vnode) {
    const maxHeight = binding.value.maxHeight;
    const fadeHeight = binding.value.fadeHeight || 30;
    const seeMoreText = binding.value.seeMoreText || 'See More';
    const seeLessText = binding.value.seeLessText || null;
    el.style.position = 'relative';
    el.style.maxHeight = `${maxHeight}px`;
    el.style.overflow = 'hidden';

    // Create a fade-out effect
    const fadeEl = document.createElement('div');
    fadeEl.style.position = 'absolute';
    fadeEl.style.bottom = '0';
    fadeEl.style.width = '100%';
    fadeEl.style.height = `${fadeHeight}px`;
    fadeEl.style.backgroundImage = `linear-gradient(to top, rgba(255, 255, 255, 1), rgba(255, 255, 255, 0))`;
    fadeEl.classList.add('expandable-fade');
    el.appendChild(fadeEl);

    // Create the "See More" button
    const buttonEl = document.createElement('button');
    buttonEl.innerText = seeMoreText;
    buttonEl.style.position = 'absolute';
    buttonEl.style.bottom = '0';
    buttonEl.style.left = '50%';
    buttonEl.style.transform = 'translateX(-50%)';
    buttonEl.style.zIndex = '10';
    buttonEl.classList.add('expandable-btn');
    el.appendChild(buttonEl);

    // Check if content overflows and hide button and fade effect accordingly
    const checkOverflow = () => {
      if (el.scrollHeight <= maxHeight) {
        buttonEl.style.display = 'none';
        fadeEl.style.display = 'none';
      } else {
        buttonEl.style.display = 'block';
        fadeEl.style.display = 'block';
      }
    };

    // Add click event listener
    buttonEl.addEventListener('click', () => {
      if (el.style.maxHeight === `${maxHeight}px`) {
        el.style.maxHeight = 'none';
        fadeEl.style.display = 'none';

        if (seeLessText) {
          buttonEl.innerText = seeLessText;
          fadeEl.style.height = `${0}px`;
        } else {
          buttonEl.style.display = 'none';
        }
      } else {
        el.style.maxHeight = `${maxHeight}px`;
        fadeEl.style.display = 'block';
        fadeEl.style.height = `${fadeHeight}px`;
        buttonEl.innerText = seeMoreText;
        buttonEl.style.display = 'block';
      }
    });

    // Listen for changes in the content
    const observer = new MutationObserver(checkOverflow);
    observer.observe(el, { childList: true, subtree: true });

    // Initial check
    vnode.context.$nextTick(checkOverflow);
  },
});
