/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.jcr.RepositoryException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.web.repository.content.WebContent;

/**
 * {@link ActivityType} implementation for news publication
 */
public class NewsPublishedActivityType extends WebContentActivityType
{
    /** data name for the content tags */
    public static final String CONTENT_TAGS = "contentTags";

    private TagProviderExtensionPoint _tagProviderExtPt;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _tagProviderExtPt = (TagProviderExtensionPoint) serviceManager.lookup(TagProviderExtensionPoint.ROLE);
    }
    
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        Content content = (Content) parameters.get(ObservationConstants.ARGS_CONTENT);
        
        List<String> tags = content.getTags().stream()
            .filter(s -> s.startsWith("WORKSPACES_TAG_"))
            .map(s -> _tagProviderExtPt.getTag(s, Map.of("siteName", ((WebContent) content).getSiteName())))
            .filter(Objects::nonNull)
            .map(t -> _i18nUtils.translate(t.getTitle(), content.getLanguage()))
            .collect(Collectors.toList());
        
        activity.setValue(CONTENT_TAGS, tags.toArray(new String[tags.size()]));
    }
}
