/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.chat;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.runtime.config.Config;

/**
 * Delete a Rocket.Chat room when a project is deleted
 */
public class ProjectDeletedObserver extends AbstractLogEnabled implements AsyncObserver, Serviceable
{
    /** Rocket.Chat helper */
    protected ChatHelper _rocketChatHelper;

    public void service(ServiceManager manager) throws ServiceException
    {
        _rocketChatHelper = (ChatHelper) manager.lookup(ChatHelper.ROLE);
    }

    public boolean supports(Event event)
    {
        return ObservationConstants.EVENT_PROJECT_DELETED.equals(event.getId()) && Config.getInstance().<Boolean>getValue("workspaces.chat.active");
    }
    
    public int getPriority(Event event)
    {
        return MAX_PRIORITY; // Yes, "MAX PRIORITY" is the lowest priority...
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String projectName = (String) event.getArguments().get(ObservationConstants.ARGS_PROJECT_NAME);
        try
        {
            _rocketChatHelper.deleteRoom(projectName);
        }
        catch (IOException e)
        {
            getLogger().error("An error occurred that prevented the room removal", e);
        }
    }

}
