/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.cmis;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.lang3.StringUtils;

/**
 * A wrapper for HttpServletRequest that correct the servletPath
 *
 */
public class CmisHttpServletRequest extends HttpServletRequestWrapper
{
    private String _servletPath;
    
    /**
     * default constructor
     * @param request the HttpServletRequest to wrap
     * @param source the cocoon matcher (without the ending slash)
     */
    public CmisHttpServletRequest(HttpServletRequest request, String source)
    {
        super(request);
        String tmp = StringUtils.substringAfter(request.getRequestURI(), request.getContextPath());
        _servletPath = tmp.substring(0, tmp.indexOf(source) + source.length());
    }

    @Override
    public String getServletPath()
    {
        return _servletPath;
    }
}
