/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.cmis;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.excalibur.source.SourceResolver;

import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.web.repository.site.SiteManager;

/**
 * Factory for {@link CmisServiceImpl}
 */
public class CmisServiceFactory extends AbstractServiceFactory implements Component, Serviceable
{
    /** The avalon role */
    public static final String ROLE = CmisServiceFactory.class.getName();
    private ProjectManager _projectManager;
    private WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    private DocumentWorkspaceModule _documentModule;
    private AmetysObjectResolver _resolver;
    private CmisTypeManager _typeManager;
    private UserManager _userManager;
    private AuthenticationTokenManager _authenticationTokenManager;
    private SourceResolver _sourceResolver;
    private CurrentUserProvider _currentUserProvider;
    private SiteManager _siteManager;
    private AddOrUpdateResourceHelper _addOrUpdateResourceHelper;
    
    @Override
    public CmisService getService(CallContext context)
    {
        return new CmisServiceImpl(context, this);
    }

    public void service(ServiceManager manager) throws ServiceException
    {
        _projectManager = (ProjectManager) manager.lookup(ProjectManager.ROLE);
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
        _userManager = (UserManager) manager.lookup(UserManager.ROLE);
        _workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO) manager.lookup(WorkspaceExplorerResourceDAO.ROLE);
        
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint) manager.lookup(WorkspaceModuleExtensionPoint.ROLE);
        _documentModule = moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        
        _authenticationTokenManager = (AuthenticationTokenManager) manager.lookup(AuthenticationTokenManager.ROLE);
        _sourceResolver = (SourceResolver) manager.lookup(SourceResolver.ROLE);
        _currentUserProvider = (CurrentUserProvider) manager.lookup(CurrentUserProvider.ROLE);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
        _addOrUpdateResourceHelper = (AddOrUpdateResourceHelper) manager.lookup(AddOrUpdateResourceHelper.ROLE);
        _typeManager = new CmisTypeManager();
    }

    /**
     * ProjectManager
     * @return ProjectManager
     */
    public ProjectManager getProjectManager()
    {
        return _projectManager;
    }

    /**
     * WorkspaceExplorerResourceDAO
     * @return WorkspaceExplorerResourceDAO
     */
    public WorkspaceExplorerResourceDAO getWorkspaceExplorerResourceDAO()
    {
        return _workspaceExplorerResourceDAO;
    }

    /**
     * AmetysObjectResolver
     * @return AmetysObjectResolver
     */
    public AmetysObjectResolver getResolver()
    {
        return _resolver;
    }

    /**
     * CmisTypeManager
     * @return CmisTypeManager
     */
    public CmisTypeManager getTypeManager()
    {
        return _typeManager;
    }

    /**
     * UserManager
     * @return UserManager
     */
    public UserManager getUserManager()
    {
        return _userManager;
    }

    /**
     * AuthenticationTokenManager
     * @return AuthenticationTokenManager
     */
    public AuthenticationTokenManager getAuthenticationTokenManager()
    {
        return _authenticationTokenManager;
    }

    /**
     * SourceResolver
     * @return SourceResolver
     */
    public SourceResolver getSourceResolver()
    {
        return _sourceResolver;
    }

    /**
     * CurrentUserProvider
     * @return CurrentUserProvider
     */
    public CurrentUserProvider getCurrentUserProvider()
    {
        return _currentUserProvider;
    }

    /**
     * SiteManager
     * @return SiteManager
     */
    public SiteManager getSiteManager()
    {
        return _siteManager;
    }

    /**
     * DocumentWorkspaceModule
     * @return DocumentWorkspaceModule
     */
    public DocumentWorkspaceModule getDocumentModule()
    {
        return _documentModule;
    }

    /**
     * AddOrUpdateResourceHelper
     * @return AddOrUpdateResourceHelper
     */
    public AddOrUpdateResourceHelper getAddOrUpdateResourceHelper()
    {
        return _addOrUpdateResourceHelper;
    }

    
}
