/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.tasks;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.component.Component;

/**
 * Component listing the available icons for a tasks list
 */
public class TasksListIconsComponent implements Component
{
    /** The component role */
    public static final String ROLE = TasksListIconsComponent.class.getName();
    
    /**
     * Get icons
     * @return the list of icon as json
     */
    public List<Map<String, String>> getIcons()
    {
        return List.of(
                Map.of("id", "1", "icon", "fa-map-signs"),
                Map.of("id", "2", "icon", "far fa-images"),
                Map.of("id", "3", "icon", "fa-bullhorn"),
                Map.of("id", "4", "icon", "far fa-clock"),
                Map.of("id", "5", "icon", "fa-chalkboard-teacher"),
                Map.of("id", "6", "icon", "fa-chart-line"),
                Map.of("id", "7", "icon", "far fa-comments"),
                Map.of("id", "8", "icon", "fa-shopping-basket"),
                Map.of("id", "9", "icon", "far fa-lightbulb"),
                Map.of("id", "10", "icon", "fa-list-ul"),
                Map.of("id", "11", "icon", "far fa-calendar-alt"),
                Map.of("id", "12", "icon", "far fa-question-circle"),
                Map.of("id", "13", "icon", "far fa-smile"),
                Map.of("id", "14", "icon", "far fa-meh")
            );
    }
    
    /**
     * Get default icon key
     * @return the default icon key
     */
    public String getDefaultKey()
    {
        return "10";
    }
}
