/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.activitystream;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.workspaces.activities.activitystream.ActivityStreamClientInteraction;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class ActivityStreamServiceAction
extends ServiceableAction {
    private ActivityStreamClientInteraction _activityStream;
    private ProjectManager _projectManager;
    private UserPreferencesManager _userPrefManager;
    private CurrentUserProvider _currentUserProvider;
    private WorkspaceModuleExtensionPoint _moduleEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._activityStream = (ActivityStreamClientInteraction)((Object)smanager.lookup(ActivityStreamClientInteraction.ROLE));
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._userPrefManager = (UserPreferencesManager)smanager.lookup(UserPreferencesManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        List<Map<String, Object>> activities;
        String siteName;
        List<String> projects;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        int limit = parameters.getParameterAsInteger("max-results", Integer.MAX_VALUE);
        boolean allActivities = parameters.getParameterAsBoolean("all", false);
        boolean markAsRead = parameters.getParameterAsBoolean("mark-as-read", false);
        Set<String> activityTypes = this._getFilteredActivityTypes(request);
        Set<String> categories = this._getFilteredCategories(request);
        String pattern = request.getParameter("pattern");
        Date fromDate = null;
        String fromDateAsStr = request.getParameter("fromDate");
        if (StringUtils.isNotEmpty((CharSequence)fromDateAsStr)) {
            fromDate = DateUtils.asDate((ZonedDateTime)DateUtils.parseZonedDateTime((String)fromDateAsStr));
        }
        Date untilDate = null;
        String untilDateAsStr = request.getParameter("untilDate");
        if (StringUtils.isNotEmpty((CharSequence)untilDateAsStr)) {
            untilDate = DateUtils.asDate((ZonedDateTime)DateUtils.parseZonedDateTime((String)untilDateAsStr));
        }
        if ((projects = this._projectManager.getProjectsForSite(siteName = WebHelper.getSiteName((Request)request))).isEmpty() || allActivities) {
            activities = this._activityStream.getActivitiesForCurrentUser(pattern, categories, activityTypes, fromDate, untilDate, limit);
        } else {
            Project project = this._projectManager.getProject(projects.get(0));
            activities = this._activityStream.getActivitiesForCurrentUser(Collections.singleton(project), activityTypes, fromDate, untilDate, pattern, limit);
        }
        UserIdentity user = this._currentUserProvider.getUser();
        if (markAsRead && user != null) {
            this._userPrefManager.setUserPreferences(user, "/workspaces/activity-stream", Map.of(), Map.of("lastUpdate", DateUtils.dateToString((Date)new Date())));
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        result.put("events", activities);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    private Set<String> _getFilteredActivityTypes(Request request) {
        String[] moduleIds = request.getParameterValues("modules");
        if (moduleIds != null) {
            return Arrays.stream(moduleIds).filter(StringUtils::isNotEmpty).map(id -> this._moduleEP.getModule((String)id)).map(WorkspaceModule::getAllowedEventTypes).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Set<String> _getFilteredCategories(Request request) {
        String[] categoryIds = request.getParameterValues("categories");
        if (categoryIds != null) {
            return Arrays.stream(categoryIds).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        return Set.of();
    }
}

