/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.projects;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.projects.AbstractProjectsActivityType;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.wall.WallContentManager;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WebContentActivityType
extends AbstractProjectsActivityType {
    public static final String PAGE_ID = "pageId";
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_SUMMARY = "contentSummary";
    public static final String CONTENT_TITLE = "contentTitle";
    public static final String CONTENT_ID = "contentId";
    private WallContentManager _wallContentManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._wallContentManager = (WallContentManager)((Object)serviceManager.lookup(WallContentManager.ROLE));
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        Page page;
        super.setAdditionalActivityData(activity, parameters);
        Content content = (Content)parameters.get("content");
        activity.setValue(CONTENT_ID, (Object)content.getId());
        activity.setValue(CONTENT_TITLE, (Object)content.getTitle());
        activity.setValue(CONTENT_SUMMARY, (Object)this._wallContentManager.getExcerpt(content, 150));
        activity.setValue(CONTENT_TYPE, (Object)content.getTypes()[0]);
        if (content instanceof WebContent && (page = (Page)Iterables.getFirst((Iterable)((WebContent)content).getReferencingPages(), null)) != null) {
            activity.setValue(PAGE_ID, (Object)page.getId());
        }
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        return false;
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        WebContent content = (WebContent)args.get("content");
        List<Project> projects = this._projectManager.getProjectsForSite(content.getSite());
        return projects.isEmpty() ? null : projects.get(0);
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        StringExpression titleExpr = new StringExpression(CONTENT_TITLE, Expression.Operator.WD, pattern);
        StringExpression summaryExpr = new StringExpression(CONTENT_SUMMARY, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        return new OrExpression(new Expression[]{titleExpr, summaryExpr});
    }
}

